/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;

public class C11Lines {
    private int cFile;
    private int cSeg;
    private List<Integer> baseSrcFile;
    private List<StartEnd> startEnd;
    private List<Integer> seg;
    private List<Integer> ccSegs;
    private List<List<Integer>> baseSrcLines;
    private List<List<StartEnd>> startEnds;
    private List<String> names;
    private List<List<Integer>> segmentNumbers;
    private List<List<List<Long>>> offsets;
    private List<List<List<Integer>>> lineNumbers;

    public static C11Lines parse(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        return new C11Lines(pdb, reader);
    }

    private C11Lines(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        int i;
        if (reader.numRemaining() < 4) {
            return;
        }
        this.cFile = reader.parseUnsignedShortVal();
        this.cSeg = reader.parseUnsignedShortVal();
        this.baseSrcFile = new ArrayList<Integer>();
        this.startEnd = new ArrayList<StartEnd>();
        this.seg = new ArrayList<Integer>();
        for (i = 0; i < this.cFile; ++i) {
            pdb.checkCanceled();
            int val = reader.parseInt();
            if (val < 0) {
                throw new PdbException("beyond our max integer limitation");
            }
            this.baseSrcFile.add(val);
        }
        for (i = 0; i < this.cSeg; ++i) {
            pdb.checkCanceled();
            StartEnd se = new StartEnd();
            se.parse(reader);
            this.startEnd.add(se);
        }
        for (i = 0; i < this.cSeg; ++i) {
            pdb.checkCanceled();
            this.seg.add(reader.parseUnsignedShortVal());
        }
        this.ccSegs = new ArrayList<Integer>();
        this.baseSrcLines = new ArrayList<List<Integer>>();
        this.startEnds = new ArrayList<List<StartEnd>>();
        this.names = new ArrayList<String>();
        this.segmentNumbers = new ArrayList<List<Integer>>();
        this.offsets = new ArrayList<List<List<Long>>>();
        this.lineNumbers = new ArrayList<List<List<Integer>>>();
        for (i = 0; i < this.cFile; ++i) {
            pdb.checkCanceled();
            reader.setIndex(this.baseSrcFile.get(i));
            int ccSeg = reader.parseUnsignedShortVal();
            this.ccSegs.add(ccSeg);
            reader.skip(2);
            ArrayList<Integer> baseSrcLn = new ArrayList<Integer>();
            for (int j = 0; j < ccSeg; ++j) {
                pdb.checkCanceled();
                baseSrcLn.add(reader.parseInt());
            }
            this.baseSrcLines.add(baseSrcLn);
            ArrayList<StartEnd> myStartEnd = new ArrayList<StartEnd>();
            for (int j = 0; j < ccSeg; ++j) {
                StartEnd se = new StartEnd();
                se.parse(reader);
                myStartEnd.add(se);
            }
            this.startEnds.add(myStartEnd);
            String name = reader.parseString(pdb, StringParseType.StringNt);
            this.names.add(name);
            ArrayList<Integer> segNums = new ArrayList<Integer>();
            ArrayList fileSegOffsets = new ArrayList();
            ArrayList fileSegLineNums = new ArrayList();
            for (int j = 0; j < ccSeg; ++j) {
                pdb.checkCanceled();
                reader.setIndex((Integer)baseSrcLn.get(j));
                int segNum = reader.parseUnsignedShortVal();
                segNums.add(segNum);
                int cPair = reader.parseUnsignedShortVal();
                ArrayList<Long> segOffsets = new ArrayList<Long>();
                for (int k = 0; k < cPair; ++k) {
                    pdb.checkCanceled();
                    segOffsets.add(reader.parseUnsignedIntVal());
                }
                fileSegOffsets.add(segOffsets);
                ArrayList<Integer> segLineNums = new ArrayList<Integer>();
                for (int k = 0; k < cPair; ++k) {
                    pdb.checkCanceled();
                    segLineNums.add(reader.parseUnsignedShortVal());
                }
                fileSegLineNums.add(segLineNums);
            }
            this.segmentNumbers.add(segNums);
            this.offsets.add(fileSegOffsets);
            this.lineNumbers.add(fileSegLineNums);
        }
    }

    public String toString() {
        return this.dump();
    }

    String dump() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("Lines-------------------------------------------------------\n");
        builder.append("cFile: " + this.cFile + " cSeg: " + this.cSeg + "\n");
        for (i = 0; i < this.cFile; ++i) {
            builder.append("baseSrcFile[" + i + "]: " + this.baseSrcFile.get(i) + "\n");
        }
        for (i = 0; i < this.cSeg; ++i) {
            builder.append(i + ": start:" + this.startEnd.get(i).getStart() + " end: " + this.startEnd.get(i).getEnd() + " seg: " + this.seg.get(i) + "\n");
        }
        for (i = 0; i < this.cFile; ++i) {
            builder.append("  file[" + i + "]: cSeg: " + this.ccSegs.get(i) + " name: " + this.names.get(i) + "\n");
            List<Integer> myBaseSrcLn = this.baseSrcLines.get(i);
            List<StartEnd> myStartEnds = this.startEnds.get(i);
            for (int j = 0; j < this.ccSegs.get(i); ++j) {
                StartEnd se = myStartEnds.get(j);
                builder.append("  " + j + ": baseSrcLn: " + myBaseSrcLn.get(j) + " start: " + se.getStart() + " end: " + se.getEnd() + "\n");
            }
            List<Integer> segNums = this.segmentNumbers.get(i);
            List<List<Long>> fileSegOffsets = this.offsets.get(i);
            List<List<Integer>> fileSegLineNums = this.lineNumbers.get(i);
            for (int j = 0; j < fileSegOffsets.size(); ++j) {
                List<Long> segOffsets = fileSegOffsets.get(j);
                List<Integer> segLineNums = fileSegLineNums.get(j);
                builder.append("  seg[" + j + "]: Seg: " + segNums.get(j) + " cPair: " + segOffsets.size() + "\n");
                for (int k = 0; k < segOffsets.size(); ++k) {
                    builder.append("  " + segLineNums.get(k) + ":" + segOffsets.get(k) + "\n");
                }
            }
        }
        builder.append("End Lines---------------------------------------------------\n");
        return builder.toString();
    }

    private class StartEnd {
        private long start;
        private long end;

        private StartEnd() {
        }

        public void parse(PdbByteReader reader) throws PdbException {
            this.start = reader.parseUnsignedIntVal();
            this.end = reader.parseUnsignedIntVal();
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

