/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target;

import com.google.common.collect.Range;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPredicates;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.Collection;
import java.util.stream.Stream;

public interface TraceObjectManager {
    public Trace getTrace();

    public TraceObjectValue createRootObject(TargetObjectSchema var1);

    public TraceObject createObject(TraceObjectKeyPath var1);

    public TargetObjectSchema getRootSchema();

    public TraceObject getRootObject();

    public TraceObject getObjectById(long var1);

    public TraceObject getObjectByCanonicalPath(TraceObjectKeyPath var1);

    public Stream<? extends TraceObject> getObjectsByPath(Range<Long> var1, TraceObjectKeyPath var2);

    public Stream<? extends TraceObjectValPath> getValuePaths(Range<Long> var1, PathPredicates var2);

    public Collection<? extends TraceObject> getAllObjects();

    public Collection<? extends TraceObjectValue> getAllValues();

    public Collection<? extends TraceObjectValue> getValuesIntersecting(Range<Long> var1, AddressRange var2);

    public <I extends TraceObjectInterface> Stream<I> queryAllInterface(Range<Long> var1, Class<I> var2);

    public void cullDisconnectedObjects();

    public void clear();
}

