/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import com.google.common.collect.Range;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceSpan;
import java.util.Objects;

public class DefaultTraceSpan
implements TraceSpan {
    private final Trace trace;
    private final Range<Long> span;
    private final int hash;

    public DefaultTraceSpan(Trace trace, Range<Long> span) {
        this.trace = trace;
        this.span = span;
        this.hash = Objects.hash(trace, span);
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public Range<Long> getSpan() {
        return this.span;
    }

    public String toString() {
        return "TraceSnap<" + this.trace + ": " + this.span + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTraceSpan)) {
            return false;
        }
        DefaultTraceSpan that = (DefaultTraceSpan)obj;
        if (this.trace != that.trace) {
            return false;
        }
        return Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(TraceSpan that) {
        if (this == that) {
            return 0;
        }
        int result = this.trace.getName().compareTo(that.getTrace().getName());
        if (result != 0) {
            return result;
        }
        result = Long.compare(DBTraceUtils.lowerEndpoint(this.span), DBTraceUtils.lowerEndpoint(that.getSpan()));
        if (result != 0) {
            return result;
        }
        result = Long.compare(DBTraceUtils.upperEndpoint(this.span), DBTraceUtils.upperEndpoint(that.getSpan()));
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

