/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithLocationView;
import ghidra.trace.database.symbol.DBTraceLabelSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceLabelSymbolView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.exception.InvalidInputException;
import java.util.concurrent.locks.Lock;

public class DBTraceLabelSymbolView
extends AbstractDBTraceSymbolSingleTypeWithLocationView<DBTraceLabelSymbol>
implements TraceLabelSymbolView {
    public DBTraceLabelSymbolView(DBTraceSymbolManager manager) {
        super(manager, SymbolType.LABEL.getID(), manager.labelStore);
    }

    @Override
    public DBTraceLabelSymbol add(Range<Long> lifespan, TraceThread thread, Address address, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException, IllegalArgumentException {
        if (source == SourceType.DEFAULT) {
            throw new IllegalArgumentException();
        }
        DBTraceSymbolManager.assertValidName(name);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.manager.trace.getThreadManager().assertIsMine(thread);
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(parent);
            this.manager.assertValidThreadAddress(thread, address);
            DBTraceLabelSymbol label = (DBTraceLabelSymbol)this.store.create();
            label.set(lifespan, thread, address, name, dbnsParent, source);
            this.manager.putID(lifespan, thread, address, label.getID());
            this.cacheForAt.notifyNewEntry(lifespan, address, label);
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.ADDED, label.getSpace(), label));
            DBTraceLabelSymbol dBTraceLabelSymbol = label;
            return dBTraceLabelSymbol;
        }
    }
}

