/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import com.google.common.collect.Range;
import db.DBHandle;
import generic.NestedIterator;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.stack.DBTraceStack;
import ghidra.trace.database.stack.DBTraceStackFrame;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceStackManager
implements TraceStackManager,
DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;
    protected final DBCachedObjectStore<DBTraceStack> stackStore;
    protected final DBCachedObjectIndex<DBTraceStack.ThreadSnap, DBTraceStack> stacksByThreadSnap;
    protected final DBCachedObjectStore<DBTraceStackFrame> frameStore;
    protected final DBCachedObjectIndex<Address, DBTraceStackFrame> framesByPC;

    public DBTraceStackManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.trace = trace;
        this.threadManager = threadManager;
        this.overlayAdapter = overlayAdapter;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.stackStore = factory.getOrCreateCachedStore("Stacks", DBTraceStack.class, (s, r) -> new DBTraceStack(this, s, r), true);
        this.stacksByThreadSnap = this.stackStore.getIndex(DBTraceStack.ThreadSnap.class, DBTraceStack.THREAD_SNAP_COLUMN);
        this.frameStore = factory.getOrCreateCachedStore("StackFrames", DBTraceStackFrame.class, (s, r) -> new DBTraceStackFrame(this, s, r), true);
        this.framesByPC = this.frameStore.getIndex(Address.class, DBTraceStackFrame.PC_COLUMN);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.stackStore.invalidateCache();
        this.frameStore.invalidateCache();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    protected DBTraceStack getStackByKey(long stackKey) {
        return (DBTraceStack)this.stackStore.getObjectAt(stackKey);
    }

    protected DBTraceStackFrame getFrameByKey(long frameKey) {
        return (DBTraceStackFrame)this.frameStore.getObjectAt(frameKey);
    }

    public static PathPredicates single(TraceObject seed, Class<? extends TargetObject> targetIf) {
        PathMatcher stackMatcher = seed.getTargetSchema().searchFor(targetIf, false);
        if (stackMatcher.getSingletonPath() == null) {
            throw new IllegalStateException("Schema doesn't provide a unique " + targetIf.getSimpleName() + " for " + seed.getCanonicalPath());
        }
        return stackMatcher.getSingletonPattern();
    }

    protected TraceObjectStack doGetOrAddObjectStack(TraceThread thread, long snap, boolean createIfAbsent) {
        TraceObjectThread objThread = (TraceObjectThread)thread;
        TraceObject obj = objThread.getObject();
        PathPredicates predicates = DBTraceStackManager.single(obj, TargetStack.class);
        if (createIfAbsent) {
            try (LockHold hold = this.trace.lockWrite();){
                TraceObjectStack stack = this.trace.getObjectManager().getSuccessor(obj, predicates, snap, TraceObjectStack.class);
                if (stack != null) {
                    TraceObjectStack traceObjectStack = stack;
                    return traceObjectStack;
                }
                List keyList = PathUtils.extend(obj.getCanonicalPath().getKeyList(), (List)predicates.getSingletonPath());
                TraceObjectStack traceObjectStack = this.trace.getObjectManager().addStack(keyList, snap);
                return traceObjectStack;
            }
        }
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectStack traceObjectStack = this.trace.getObjectManager().getSuccessor(obj, predicates, snap, TraceObjectStack.class);
            return traceObjectStack;
        }
    }

    protected TraceObjectStack doGetLatestObjectStack(TraceThread thread, long snap) {
        TraceObjectThread objThread = (TraceObjectThread)thread;
        TraceObject obj = objThread.getObject();
        List keyList = DBTraceStackManager.single(obj, TargetStack.class).getSingletonPath();
        return this.trace.getObjectManager().getLatestSuccessor(obj, TraceObjectKeyPath.of(keyList), snap, TraceObjectStack.class);
    }

    @Override
    public TraceStack getStack(TraceThread thread, long snap, boolean createIfAbsent) {
        this.threadManager.assertIsMine(thread);
        if (this.trace.getObjectManager().hasSchema()) {
            return this.doGetOrAddObjectStack(thread, snap, createIfAbsent);
        }
        DBTraceStack.ThreadSnap key = new DBTraceStack.ThreadSnap(thread.getKey(), snap);
        if (createIfAbsent) {
            DBTraceStack stack;
            try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
                stack = (DBTraceStack)this.stacksByThreadSnap.getOne((Object)key);
                if (stack != null) {
                    DBTraceStack dBTraceStack = stack;
                    return dBTraceStack;
                }
                stack = (DBTraceStack)this.stackStore.create();
                stack.set(thread, snap);
            }
            this.trace.setChanged(new TraceChangeRecord(Trace.TraceStackChangeType.ADDED, null, stack));
            return stack;
        }
        return (TraceStack)this.stacksByThreadSnap.getOne((Object)key);
    }

    @Override
    public TraceStack getLatestStack(TraceThread thread, long snap) {
        this.threadManager.assertIsMine(thread);
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            if (this.trace.getObjectManager().hasSchema()) {
                TraceObjectStack traceObjectStack = this.doGetLatestObjectStack(thread, snap);
                return traceObjectStack;
            }
            DBTraceStack found = (DBTraceStack)this.stacksByThreadSnap.floorValue((Object)new DBTraceStack.ThreadSnap(thread.getKey(), snap));
            if (found == null) {
                TraceStack traceStack = null;
                return traceStack;
            }
            if (found.getThread() != thread || found.getSnap() > snap) {
                TraceStack traceStack = null;
                return traceStack;
            }
            DBTraceStack dBTraceStack = found;
            return dBTraceStack;
        }
    }

    @Override
    public Iterable<TraceStackFrame> getFramesIn(AddressSetView set) {
        if (this.trace.getObjectManager().hasSchema()) {
            return () -> NestedIterator.start((Iterator)set.iterator(), rng -> this.trace.getObjectManager().getObjectsIntersecting((Range<Long>)Range.all(), (AddressRange)rng, "_pc", TraceObjectStackFrame.class).iterator());
        }
        return () -> NestedIterator.start((Iterator)set.iterator(), rng -> this.framesByPC.sub((Object)rng.getMinAddress(), true, (Object)rng.getMaxAddress(), true).values().iterator());
    }

    protected void deleteStack(DBTraceStack stack) {
        this.stackStore.delete((DBAnnotatedObject)stack);
    }

    protected DBTraceStackFrame createFrame(DBTraceStack stack) {
        DBTraceStackFrame frame = (DBTraceStackFrame)this.frameStore.create();
        frame.set(stack);
        return frame;
    }

    protected void deleteFrame(DBTraceStackFrame frame) {
        this.frameStore.delete((DBAnnotatedObject)frame);
    }
}

