/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.context.DBTraceRegisterContextManager;
import ghidra.trace.database.context.DBTraceRegisterContextSpace;
import ghidra.trace.database.guest.InternalTracePlatform;
import ghidra.trace.database.listing.AbstractBaseDBTraceDefinedUnitsView;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceInstruction;
import ghidra.trace.database.listing.InternalTraceBaseDefinedUnitsView;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.listing.TraceInstructionsView;
import ghidra.trace.util.OverlappingObjectIterator;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.tuple.Pair;

public class DBTraceInstructionsView
extends AbstractBaseDBTraceDefinedUnitsView<DBTraceInstruction>
implements TraceInstructionsView,
InternalTraceBaseDefinedUnitsView<TraceInstruction> {
    protected static <T> T replaceIfNotNull(T cur, T rep) {
        return rep != null ? rep : cur;
    }

    public DBTraceInstructionsView(DBTraceCodeSpace space) {
        super(space, space.instructionMapSpace);
    }

    protected void doSetContext(TraceAddressSnapRange tasr, Language language, ProcessorContextView context) {
        Register contextReg = language.getContextBaseRegister();
        if (contextReg == null || contextReg == Register.NO_CONTEXT) {
            return;
        }
        RegisterValue newValue = context.getRegisterValue(contextReg);
        DBTraceRegisterContextManager ctxMgr = this.space.trace.getRegisterContextManager();
        if (Objects.equals(ctxMgr.getDefaultValue(language, contextReg, tasr.getX1()), newValue)) {
            DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)ctxMgr.get(this.space, false);
            if (ctxSpace == null) {
                return;
            }
            ctxSpace.removeValue(language, contextReg, tasr.getLifespan(), tasr.getRange());
            return;
        }
        DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)ctxMgr.get(this.space, true);
        ctxSpace.setValue(language, newValue, tasr.getLifespan(), tasr.getRange());
    }

    protected DBTraceInstruction doCreate(Range<Long> lifespan, Address address, InternalTracePlatform platform, InstructionPrototype prototype, ProcessorContextView context) throws CodeUnitInsertionException, AddressOverflowException {
        DBTraceMemorySpace memSpace;
        long endSnap;
        if (platform.getLanguage() != prototype.getLanguage()) {
            throw new IllegalArgumentException("Platform and prototype disagree in language");
        }
        Address endAddress = address.addNoWrap((long)(prototype.getLength() - 1));
        AddressRangeImpl createdRange = new AddressRangeImpl(address, endAddress);
        if (!lifespan.hasUpperBound()) {
            lifespan = this.space.instructions.truncateSoonestDefined(lifespan, (AddressRange)createdRange);
            lifespan = this.space.definedData.truncateSoonestDefined(lifespan, (AddressRange)createdRange);
        }
        endSnap = (endSnap = (memSpace = this.space.trace.getMemoryManager().getMemorySpace(this.space.space, true)).getFirstChange(lifespan, (AddressRange)createdRange)) == Long.MIN_VALUE ? DBTraceUtils.upperEndpoint(lifespan) : --endSnap;
        ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange((AddressRange)createdRange, DBTraceUtils.toRange(DBTraceUtils.lowerEndpoint(lifespan), endSnap));
        if (!this.space.undefinedData.coversRange(tasr)) {
            throw new CodeUnitInsertionException("Code units cannot overlap");
        }
        this.doSetContext(tasr, prototype.getLanguage(), context);
        DBTraceInstruction created = this.space.instructionMapSpace.put(tasr, null);
        created.set(platform, prototype, context);
        this.cacheForContaining.notifyNewEntry(lifespan, (AddressRange)createdRange, created);
        this.cacheForSequence.notifyNewEntry(lifespan, createdRange, created);
        this.space.undefinedData.invalidateCache();
        return created;
    }

    @Override
    public DBTraceInstruction create(Range<Long> lifespan, Address address, TracePlatform platform, InstructionPrototype prototype, ProcessorContextView context) throws CodeUnitInsertionException {
        DBTraceInstruction dBTraceInstruction;
        block8: {
            InternalTracePlatform dbPlatform = this.space.manager.platformManager.assertMine(platform);
            LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());
            try {
                DBTraceInstruction created = this.doCreate(lifespan, address, dbPlatform, prototype, context);
                this.space.trace.setChanged(new TraceChangeRecord<DBTraceInstruction, DBTraceInstruction>(Trace.TraceCodeChangeType.ADDED, this.space, created, created));
                dBTraceInstruction = created;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AddressOverflowException e) {
                    throw new CodeUnitInsertionException("Code unit would extend beyond address space");
                }
            }
            hold.close();
        }
        return dBTraceInstruction;
    }

    protected OverlappingObjectIterator<Instruction, CodeUnit> startCheckingBlock(long startSnap, InstructionBlock block) {
        Address startAddress = block.getStartAddress();
        TraceCodeUnit found = this.space.definedUnits.getContaining(startSnap, startAddress);
        if (found != null) {
            startAddress = found.getAddress();
        }
        Iterator instructions = block.iterator();
        Iterator existing = this.space.definedUnits.get(startSnap, startAddress, true).iterator();
        return new OverlappingObjectIterator<CodeUnit, CodeUnit>(instructions, OverlappingObjectIterator.CODE_UNIT, existing, OverlappingObjectIterator.CODE_UNIT);
    }

    protected InstructionBlockAdder startAddingBlock(Range<Long> lifespan, Set<Address> skipDelaySlots, InternalTracePlatform platform, InstructionBlock block) {
        InstructionError conflict = block.getInstructionConflict();
        if (conflict == null) {
            return new InstructionBlockAdder(skipDelaySlots, lifespan, platform, block, null, null, null);
        }
        Address errorAddress = conflict.getInstructionAddress();
        if (errorAddress == null) {
            return null;
        }
        if (!conflict.getInstructionErrorType().isConflict) {
            return new InstructionBlockAdder(skipDelaySlots, lifespan, platform, block, errorAddress, conflict, null);
        }
        long startSnap = DBTraceUtils.lowerEndpoint(lifespan);
        TraceCodeUnit conflictCodeUnit = this.space.definedUnits.getAt(startSnap, conflict.getConflictAddress());
        return new InstructionBlockAdder(skipDelaySlots, lifespan, platform, block, errorAddress, conflict, conflictCodeUnit);
    }

    protected void checkInstructionSet(long startSnap, InstructionSet instructionSet, Set<Address> skipDelaySlots) {
        block0: for (InstructionBlock block : instructionSet) {
            Address errorAddress = null;
            InstructionError conflict = block.getInstructionConflict();
            if (conflict != null && (errorAddress = conflict.getInstructionAddress()) == null || block.isEmpty()) continue;
            Address flowFromAddress = block.getFlowFromAddress();
            Instruction lastProtoInstr = null;
            OverlappingObjectIterator<Instruction, CodeUnit> overlapIt = this.startCheckingBlock(startSnap, block);
            while (overlapIt.hasNext()) {
                Pair overlap = (Pair)overlapIt.next();
                Instruction protoInstr = (Instruction)overlap.getLeft();
                if (errorAddress != null && protoInstr.getAddress().compareTo((Object)errorAddress) >= 0) continue block0;
                if (lastProtoInstr != protoInstr) {
                    flowFromAddress = protoInstr.getAddress();
                    lastProtoInstr = protoInstr;
                }
                CodeUnit existsCu = (CodeUnit)overlap.getRight();
                int cmp = existsCu.getMinAddress().compareTo((Object)protoInstr.getMinAddress());
                boolean existsIsInstruction = existsCu instanceof TraceInstruction;
                if (cmp == 0 && existsIsInstruction) {
                    TraceInstruction existsInstr = (TraceInstruction)existsCu;
                    if (protoInstr.isInDelaySlot() != existsInstr.isInDelaySlot() && protoInstr.getLength() == existsInstr.getLength()) {
                        if (protoInstr.isInDelaySlot()) {
                            existsInstr.delete();
                            continue;
                        }
                        skipDelaySlots.add(existsInstr.getAddress());
                        continue;
                    }
                    if (!protoInstr.getPrototype().equals(existsInstr.getPrototype())) {
                        InstructionError.dumpInstructionDifference((Instruction)protoInstr, (Instruction)existsInstr);
                        block.setInconsistentPrototypeConflict(existsInstr.getAddress(), flowFromAddress);
                        continue block0;
                    }
                    block.setInstructionError(InstructionError.InstructionErrorType.DUPLICATE, protoInstr.getAddress(), existsInstr.getAddress(), flowFromAddress, null);
                    continue block0;
                }
                block.setCodeUnitConflict(existsCu.getAddress(), protoInstr.getAddress(), flowFromAddress, existsIsInstruction, existsIsInstruction);
            }
        }
    }

    @Override
    public AddressSetView addInstructionSet(Range<Long> lifespan, TracePlatform platform, InstructionSet instructionSet, boolean overwrite) {
        Iterator iterator;
        block13: {
            InternalTracePlatform dbPlatform = this.space.manager.platformManager.assertMine(platform);
            AddressSet result = new AddressSet();
            LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());
            try {
                long startSnap = DBTraceUtils.lowerEndpoint(lifespan);
                HashSet<Address> skipDelaySlots = new HashSet<Address>();
                if (overwrite) {
                    for (AddressRange range : instructionSet.getAddressSet()) {
                        this.space.definedUnits.clear(lifespan, range, false, TaskMonitor.DUMMY);
                    }
                } else {
                    this.checkInstructionSet(startSnap, instructionSet, skipDelaySlots);
                }
                for (InstructionBlock block : instructionSet) {
                    InstructionBlockAdder adder = this.startAddingBlock(lifespan, skipDelaySlots, dbPlatform, block);
                    if (adder == null) continue;
                    Instruction lastInstruction = adder.doAddInstructions();
                    block.setInstructionsAddedCount(adder.count);
                    if (lastInstruction == null) continue;
                    Address maxAddress = DBTraceCodeManager.instructionMax(lastInstruction, true);
                    result.addRange(block.getStartAddress(), maxAddress);
                    this.space.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, TraceCodeUnit>(Trace.TraceCodeChangeType.ADDED, this.space, new ImmutableTraceAddressSnapRange(block.getStartAddress(), maxAddress, lifespan)));
                }
                iterator = result;
                if (hold == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CancelledException e) {
                    throw new AssertionError((Object)e);
                }
                catch (AddressOverflowException e) {
                    throw new AssertionError((Object)e);
                }
            }
            hold.close();
        }
        return iterator;
    }

    protected class InstructionBlockAdder {
        private final Set<Address> skipDelaySlots;
        private final Range<Long> lifespan;
        private final InternalTracePlatform platform;
        private final InstructionBlock block;
        private final Address errorAddress;
        private final InstructionError conflict;
        private final CodeUnit conflictCodeUnit;
        protected int count = 0;

        private InstructionBlockAdder(Set<Address> skipDelaySlots, Range<Long> lifespan, InternalTracePlatform platform, InstructionBlock block, Address errorAddress, InstructionError conflict, CodeUnit conflictCodeUnit) {
            this.skipDelaySlots = skipDelaySlots;
            this.lifespan = lifespan;
            this.platform = platform;
            this.block = block;
            this.errorAddress = errorAddress;
            this.conflict = conflict;
            this.conflictCodeUnit = conflictCodeUnit;
        }

        protected Instruction doCreateInstruction(Address address, InstructionPrototype prototype, Instruction protoInstr) {
            try {
                FlowOverride flowOverride;
                DBTraceInstruction created = DBTraceInstructionsView.this.doCreate(this.lifespan, address, this.platform, prototype, (ProcessorContextView)protoInstr);
                if (protoInstr.isFallThroughOverridden()) {
                    created.setFallThrough(protoInstr.getFallThrough());
                }
                if ((flowOverride = protoInstr.getFlowOverride()) != FlowOverride.NONE) {
                    created.setFlowOverride(flowOverride);
                }
                return created;
            }
            catch (AddressOverflowException | CodeUnitInsertionException e) {
                throw new AssertionError((Object)e);
            }
        }

        protected Instruction doAddInstructions(Iterator<Instruction> it, boolean areDelaySlots) {
            Instruction lastInstruction = null;
            while (it.hasNext()) {
                Instruction protoInstr = it.next();
                Address startAddress = protoInstr.getAddress();
                try {
                    if (this.conflictCodeUnit != null) {
                        if (this.errorAddress.compareTo((Object)DBTraceCodeManager.instructionMax(protoInstr, false)) <= 0) {
                            Address flowFromAddress = lastInstruction != null ? lastInstruction.getAddress() : this.block.getFlowFromAddress();
                            this.block.setCodeUnitConflict(this.conflict.getConflictAddress(), startAddress, flowFromAddress, this.conflict.isInstructionConflict(), false);
                            return lastInstruction;
                        }
                        if (this.errorAddress.compareTo((Object)DBTraceCodeManager.instructionMax(protoInstr, true)) <= 0) {
                            return lastInstruction;
                        }
                    }
                }
                catch (AddressOverflowException e) {
                    return lastInstruction;
                }
                if (!this.skipDelaySlots.contains(startAddress)) {
                    InstructionPrototype prototype = protoInstr.getPrototype();
                    if (!areDelaySlots && prototype.hasDelaySlots()) {
                        ArrayDeque<Instruction> delayed = new ArrayDeque<Instruction>(protoInstr.getDelaySlotDepth());
                        for (int i = delayed.size(); i >= 0 && it.hasNext(); --i) {
                            delayed.push(it.next());
                        }
                        lastInstruction = DBTraceInstructionsView.replaceIfNotNull(lastInstruction, this.doAddInstructions(delayed.iterator(), true));
                    }
                    lastInstruction = this.doCreateInstruction(startAddress, prototype, protoInstr);
                }
                if (this.errorAddress == null || this.conflictCodeUnit != null || this.errorAddress.compareTo((Object)startAddress) > 0) continue;
                return lastInstruction;
            }
            return lastInstruction;
        }

        protected Instruction doAddInstructions() {
            return this.doAddInstructions(this.block.iterator(), false);
        }
    }
}

