/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.data.DBTraceDataTypeManager;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.database.listing.AbstractDBTraceCodeUnit;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeUnitsView;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.listing.DBTraceDataView;
import ghidra.trace.database.listing.DBTraceDefinedDataView;
import ghidra.trace.database.listing.DBTraceDefinedUnitsView;
import ghidra.trace.database.listing.DBTraceInstruction;
import ghidra.trace.database.listing.DBTraceInstructionsView;
import ghidra.trace.database.listing.DBTraceUndefinedDataView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.symbol.DBTraceReferenceManager;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceCodeSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.ByteArrayUtils;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceCodeSpace
implements TraceCodeSpace,
DBTraceSpaceBased {
    protected final DBTraceCodeManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final TraceThread thread;
    protected final int frameLevel;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final DBTraceDataTypeManager dataTypeManager;
    protected final DBTraceReferenceManager referenceManager;
    protected final AddressRange all;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceInstruction, DBTraceInstruction> instructionMapSpace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceData, DBTraceData> dataMapSpace;
    protected DBTraceInstructionsView instructions;
    protected DBTraceDefinedDataView definedData;
    protected DBTraceUndefinedDataView undefinedData;
    protected DBTraceDataView data;
    protected DBTraceDefinedUnitsView definedUnits;
    protected DBTraceCodeUnitsView codeUnits;

    public DBTraceCodeSpace(DBTraceCodeManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent, TraceThread thread) throws VersionException, IOException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.thread = thread;
        this.frameLevel = ent.getFrameLevel();
        this.lock = manager.getLock();
        this.baseLanguage = manager.getBaseLanguage();
        this.trace = manager.getTrace();
        this.dataTypeManager = manager.dataTypeManager;
        this.referenceManager = manager.referenceManager;
        this.all = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        long threadKey = ent.getThreadKey();
        int frameLevel = ent.getFrameLevel();
        this.instructionMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceInstruction.tableName(space, threadKey), factory, this.lock, space, null, 0, DBTraceInstruction.class, (t, s, r) -> new DBTraceInstruction(this, t, (DBCachedObjectStore<?>)s, r));
        this.dataMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceData.tableName(space, threadKey, frameLevel), factory, this.lock, space, null, 0, DBTraceData.class, (t, s, r) -> new DBTraceData(this, t, (DBCachedObjectStore<?>)s, r));
        this.instructions = this.createInstructionsView();
        this.definedData = this.createDefinedDataView();
        this.definedUnits = this.createDefinedUnitsView();
        this.undefinedData = this.createUndefinedDataView();
        this.data = this.createDataView();
        this.codeUnits = this.createCodeUnitsView();
    }

    protected DBTraceInstructionsView createInstructionsView() {
        return new DBTraceInstructionsView(this);
    }

    protected DBTraceDefinedDataView createDefinedDataView() {
        return new DBTraceDefinedDataView(this);
    }

    protected DBTraceDefinedUnitsView createDefinedUnitsView() {
        return new DBTraceDefinedUnitsView(this);
    }

    protected DBTraceUndefinedDataView createUndefinedDataView() {
        return new DBTraceUndefinedDataView(this);
    }

    protected DBTraceDataView createDataView() {
        return new DBTraceDataView(this);
    }

    protected DBTraceCodeUnitsView createCodeUnitsView() {
        return new DBTraceCodeUnitsView(this);
    }

    void clearPlatform(Range<Long> span, AddressRange range, DBTraceGuestPlatform guest, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Clearing instructions");
        monitor.setMaximum((long)this.instructionMapSpace.size());
        this.instructions.invalidateCache();
        this.definedData.invalidateCache();
        this.undefinedData.invalidateCache();
        for (DBTraceInstruction instruction : this.instructionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            if (instruction.platform != guest) continue;
            this.instructionMapSpace.deleteData(instruction);
            this.instructions.unitRemoved(instruction);
        }
        monitor.setMessage("Clearing data");
        monitor.setMaximum((long)this.dataMapSpace.size());
        for (DBTraceData dataUnit : this.dataMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            if (dataUnit.platform != guest) continue;
            this.dataMapSpace.deleteData(dataUnit);
            this.definedData.unitRemoved(dataUnit);
        }
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    @Override
    public DBTraceCodeUnitsView codeUnits() {
        return this.codeUnits;
    }

    @Override
    public DBTraceInstructionsView instructions() {
        return this.instructions;
    }

    @Override
    public DBTraceDataView data() {
        return this.data;
    }

    @Override
    public DBTraceDefinedDataView definedData() {
        return this.definedData;
    }

    @Override
    public DBTraceUndefinedDataView undefinedData() {
        return this.undefinedData;
    }

    @Override
    public DBTraceDefinedUnitsView definedUnits() {
        return this.definedUnits;
    }

    @Override
    public void invalidateCache() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.instructionMapSpace.invalidateCache();
            this.instructions.invalidateCache();
            this.dataMapSpace.invalidateCache();
            this.definedData.invalidateCache();
            this.undefinedData.invalidateCache();
        }
    }

    public void bytesChanged(Set<TraceAddressSnapRange> changed, long snap, Address start, byte[] oldBytes, byte[] newBytes) {
        AddressSet diffs = ByteArrayUtils.computeDiffsAddressSet(start, oldBytes, newBytes);
        HashSet<AbstractDBTraceCodeUnit> affectedUnits = new HashSet<AbstractDBTraceCodeUnit>();
        for (TraceAddressSnapRange box : changed) {
            if (!diffs.intersects(box.getX1(), box.getX2())) continue;
            for (AbstractDBTraceCodeUnit unit : this.definedUnits.getIntersecting(box)) {
                if (!diffs.intersects(unit.getMinAddress(), unit.getMaxAddress())) continue;
                affectedUnits.add(unit);
            }
        }
        ByteMemBufferImpl newBuf = new ByteMemBufferImpl(start, newBytes, this.trace.getBaseLanguage().isBigEndian());
        for (AbstractDBTraceCodeUnit unit : affectedUnits) {
            WrappedMemBuffer newWrapped;
            Dynamic ddt;
            int newLength;
            long unitStartSnap;
            long unitEndSnap = unit.getEndSnap();
            if (unit.getStartSnap() < snap) {
                unit.setEndSnap(snap - 1L);
                unitStartSnap = snap;
            } else {
                unitStartSnap = unit.getStartSnap();
                unit.delete();
            }
            if (!(unit instanceof DBTraceData)) continue;
            DBTraceData dataUnit = (DBTraceData)unit;
            boolean reApply = false;
            DataType dataType = dataUnit.getDataType();
            reApply = dataType instanceof Dynamic ? (newLength = (ddt = (Dynamic)dataType).getLength((MemBuffer)(newWrapped = new WrappedMemBuffer((MemBuffer)newBuf, (int)dataUnit.getAddress().subtract(start))), dataUnit.getLength())) == unit.getLength() : true;
            if (!reApply) continue;
            try {
                this.definedData.create((Range)DBTraceUtils.toRange(unitStartSnap, unitEndSnap), unit.getAddress(), dataType, unit.getLength());
            }
            catch (CodeUnitInsertionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

