/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.data.DBTraceDataSettingsAdapter;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.listing.DBTraceDefinedDataAdapter;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;

public abstract class AbstractDBTraceDataComponent
implements DBTraceDefinedDataAdapter {
    protected final DBTraceData root;
    protected final DBTraceDefinedDataAdapter parent;
    protected final int index;
    protected final Address address;
    protected final DataType dataType;
    protected final int length;
    protected final int level;
    protected final DataType baseDataType;
    protected final Address maxAddress;
    protected final Settings defaultSettings;
    protected int[] path;
    protected AbstractDBTraceDataComponent[] componentCache = null;

    public AbstractDBTraceDataComponent(DBTraceData root, DBTraceDefinedDataAdapter parent, int index, Address address, DataType dataType, int length) {
        this.root = root;
        this.parent = parent;
        this.index = index;
        this.address = address;
        this.dataType = dataType;
        this.length = length;
        this.level = parent.getComponentLevel() + 1;
        this.baseDataType = DBTraceData.getBaseDataType(dataType);
        this.maxAddress = address.add((long)(length - 1));
        this.defaultSettings = dataType.getDefaultSettings();
    }

    public String toString() {
        return this.doToString();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Either delete the root, or modify the type");
    }

    @Override
    public DBTrace getTrace() {
        return this.root.getTrace();
    }

    @Override
    public TraceThread getThread() {
        return this.root.getThread();
    }

    @Override
    public TracePlatform getPlatform() {
        return this.root.getPlatform();
    }

    @Override
    public Language getLanguage() {
        return this.root.getLanguage();
    }

    @Override
    public Range<Long> getLifespan() {
        return this.root.getLifespan();
    }

    @Override
    public long getStartSnap() {
        return this.root.getStartSnap();
    }

    @Override
    public void setEndSnap(long endSnap) {
        throw new UnsupportedOperationException("Set end-snap of root unit");
    }

    @Override
    public long getEndSnap() {
        return this.root.getEndSnap();
    }

    public Address getAddress() {
        return this.address;
    }

    public Address getMaxAddress() {
        return this.maxAddress;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int getBytes(ByteBuffer buffer, int addressOffset) {
        int componentOffset = (int)this.address.subtract(this.root.getAddress());
        return this.root.getBytes(buffer, addressOffset + componentOffset);
    }

    @Override
    public AbstractDBTraceDataComponent[] doGetComponentCache() {
        if (this.componentCache == null) {
            this.componentCache = new AbstractDBTraceDataComponent[this.getNumComponents()];
        }
        return this.componentCache;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataType getBaseDataType() {
        return this.baseDataType;
    }

    public int[] getComponentPath() {
        try (LockHold hold = LockHold.lock((Lock)this.root.space.lock.writeLock());){
            if (this.path != null) {
                int[] nArray = this.path;
                return nArray;
            }
            this.path = new int[this.level];
            DBTraceDefinedDataAdapter a = this;
            for (int i = this.level - 1; i >= 0; --i) {
                this.path[i] = a.getComponentIndex();
                a = a.getParent();
            }
            assert (a.getRoot() == a);
            int[] nArray = this.path;
            return nArray;
        }
    }

    public String getPathName() {
        return this.getPathName(new StringBuilder(), true).toString();
    }

    public String getComponentPathName() {
        return this.getPathName(new StringBuilder(), false).toString();
    }

    public abstract String getFieldSyntax();

    @Override
    public StringBuilder getPathName(StringBuilder builder, boolean includeRootSymbol) {
        return this.parent.getPathName(builder, includeRootSymbol).append(this.getFieldSyntax());
    }

    @Override
    public DBTraceDefinedDataAdapter getParent() {
        return this.parent;
    }

    @Override
    public DBTraceData getRoot() {
        return this.root;
    }

    public int getRootOffset() {
        return (int)this.address.subtract(this.root.getAddress());
    }

    public int getParentOffset() {
        return (int)this.address.subtract(this.parent.getAddress());
    }

    public int getComponentIndex() {
        return this.index;
    }

    public int getComponentLevel() {
        return this.level;
    }

    @Override
    public DBTraceDataSettingsAdapter.DBTraceDataSettingsSpace getSettingsSpace(boolean createIfAbsent) {
        return (DBTraceDataSettingsAdapter.DBTraceDataSettingsSpace)this.root.getSettingsSpace(createIfAbsent);
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }
}

