/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import com.google.common.collect.Range;
import ghidra.pcode.exec.trace.data.DefaultPcodeTracePropertyAccess;
import ghidra.pcode.exec.trace.data.InternalPcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryOperations;
import ghidra.trace.model.memory.TraceMemoryState;
import java.nio.ByteBuffer;

public abstract class AbstractPcodeTraceDataAccess
implements InternalPcodeTraceDataAccess {
    protected final TracePlatform platform;
    protected final long snap;
    protected final TraceTimeViewport viewport;
    protected final TraceMemoryManager mm;

    public AbstractPcodeTraceDataAccess(TracePlatform platform, long snap, TraceTimeViewport viewport) {
        this.platform = platform;
        this.snap = snap;
        this.viewport = viewport;
        this.mm = platform.getTrace().getMemoryManager();
    }

    @Override
    public TraceTimeViewport getViewport() {
        return this.viewport;
    }

    @Override
    public Language getLanguage() {
        return this.platform.getLanguage();
    }

    @Override
    public TracePlatform getPlatform() {
        return this.platform;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    protected abstract TraceMemoryOperations getMemoryOps(boolean var1);

    protected abstract Address toOverlay(Address var1);

    protected abstract AddressRange toOverlay(AddressRange var1);

    protected abstract AddressSetView toOverlay(AddressSetView var1);

    @Override
    public void setState(AddressRange guestRange, TraceMemoryState state) {
        AddressRange hostRange = this.platform.mapGuestToHost(guestRange);
        if (hostRange == null) {
            return;
        }
        this.getMemoryOps(true).setState(this.snap, this.toOverlay(hostRange), state);
    }

    @Override
    public TraceMemoryState getViewportState(AddressRange guestRange) {
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            return TraceMemoryState.UNKNOWN;
        }
        AddressRange hostRange = this.platform.mapGuestToHost(guestRange);
        if (hostRange == null) {
            return TraceMemoryState.UNKNOWN;
        }
        AddressSet hostSet = new AddressSet(this.toOverlay(hostRange));
        for (long snap : this.viewport.getOrderedSnaps()) {
            hostSet.delete(ops.getAddressesWithState(snap, (AddressSetView)hostSet, s -> s == TraceMemoryState.KNOWN));
        }
        return hostSet.isEmpty() ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    protected AddressSetView doGetKnown(Range<Long> span) {
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            return new AddressSet();
        }
        return this.platform.mapHostToGuest(ops.getAddressesWithState(span, s -> s == TraceMemoryState.KNOWN));
    }

    @Override
    public AddressSetView getKnownNow() {
        return this.doGetKnown((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.snap)));
    }

    @Override
    public AddressSetView getKnownBefore() {
        return this.doGetKnown((Range<Long>)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(this.snap)));
    }

    @Override
    public AddressSetView intersectUnknown(AddressSetView guestView) {
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            return guestView;
        }
        AddressSetView hostView = this.toOverlay(this.platform.mapGuestToHost(guestView));
        AddressSetView hostKnown = ops.getAddressesWithState(this.snap, hostView, s -> s != null && s != TraceMemoryState.UNKNOWN);
        AddressSet hostResult = hostView.subtract(hostKnown);
        return this.platform.mapHostToGuest((AddressSetView)hostResult);
    }

    @Override
    public int putBytes(Address start, ByteBuffer buf) {
        Address hostStart = this.platform.mapGuestToHost(start);
        if (hostStart == null) {
            return 0;
        }
        return this.getMemoryOps(true).putBytes(this.snap, this.toOverlay(hostStart), buf);
    }

    @Override
    public int getBytes(Address start, ByteBuffer buf) {
        Address hostStart = this.platform.mapGuestToHost(start);
        if (hostStart == null) {
            return 0;
        }
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            int length = buf.remaining();
            buf.position(buf.position() + length);
            return length;
        }
        return ops.getViewBytes(this.snap, this.toOverlay(hostStart), buf);
    }

    @Override
    public Address translate(Address address) {
        Address host = this.platform.mapGuestToHost(address);
        if (host == null) {
            return null;
        }
        return this.toOverlay(host);
    }

    @Override
    public <T> PcodeTracePropertyAccess<T> getPropertyAccess(String name, Class<T> type) {
        return new DefaultPcodeTracePropertyAccess<T>(this, name, type);
    }
}

