/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.graph.exporter.AbstractAttributedGraphExporter;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import java.io.File;
import java.io.IOException;
import org.jgrapht.Graph;
import org.jgrapht.nio.dimacs.DIMACSExporter;
import org.jgrapht.nio.dimacs.DIMACSFormat;
import org.jgrapht.nio.dot.DOTExporter;

public class DotGraphExporter
extends AbstractAttributedGraphExporter {
    protected DIMACSFormat dimacsFormat = DIMACSExporter.DEFAULT_DIMACS_FORMAT;

    public void exportGraph(AttributedGraph graph, File file) throws IOException {
        DOTExporter exporter = new DOTExporter(this::getQuotedId);
        exporter.setVertexAttributeProvider(this::getAttributes);
        exporter.setEdgeAttributeProvider(this::getAttributes);
        exporter.setGraphIdProvider(this.graphIdProvider);
        try {
            exporter.exportGraph((Graph)graph, file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getFileExtension() {
        return "gf";
    }

    public String getName() {
        return "DOT";
    }

    public String getDesciption() {
        return "JGraphT library export of a graph to a DOT file";
    }

    String getQuotedId(AttributedVertex vertex) {
        String id = (String)this.vertexIdProvider.apply(vertex);
        return "\"" + id + "\"";
    }
}

