/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.shell;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.util.GetlineCompleter;

public class CollectionCompleter
implements GetlineCompleter {
    private ArrayList completions = new ArrayList();
    private ShellBase shell = null;
    private PrintStream out = System.out;
    private Collection collection;

    public CollectionCompleter() {
    }

    public CollectionCompleter(ShellBase shell) {
        this.shell = shell;
        this.out = shell.getOutStream();
    }

    public CollectionCompleter(ShellBase shell, Collection collection) {
        this(shell);
        this.setCollection(collection);
    }

    public Iterator getIterator() {
        return this.getCollection().iterator();
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    private boolean startsWith(String substr, String[] possible) {
        for (int i = 0; i < possible.length; ++i) {
            if (possible[i].startsWith(substr)) continue;
            return false;
        }
        return true;
    }

    public String getPartialCompletion(String[] possible) {
        if (possible.length == 0) {
            return "";
        }
        String match = possible[0];
        StringBuffer lcd = new StringBuffer();
        for (int i = 0; i < match.length() && this.startsWith(match.substring(0, i + 1), possible); ++i) {
            lcd.append(match.charAt(i));
        }
        return lcd.toString();
    }

    public String displayPossible(List possible) {
        return this.displayPossible(possible.toArray(new String[possible.size()]));
    }

    public String displayPossible(String[] possible) {
        int size = possible.length;
        String partial = this.getPartialCompletion(possible);
        for (int i = 0; i < size; ++i) {
            String match = possible[i];
            this.out.println();
            this.out.print(match + " ");
        }
        if (this.shell != null) {
            this.shell.getGetline().redraw();
        }
        if (partial.length() > 0) {
            return partial;
        }
        return null;
    }

    public String complete(String line) {
        this.completions.clear();
        int len = line.length();
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (len != 0 && !name.startsWith(line)) continue;
            this.completions.add(name);
        }
        int size = this.completions.size();
        switch (size) {
            case 0: {
                return line;
            }
            case 1: {
                return (String)this.completions.get(0);
            }
        }
        String partial = this.displayPossible(this.completions);
        if (partial != null) {
            return partial;
        }
        return line;
    }
}

