/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.Table;
import ghidra.util.database.AbstractDirectedLongKeyIterator;
import ghidra.util.database.BackwardLongKeyIterator;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.ForwardLongKeyIterator;
import java.io.IOException;

public interface DirectedLongKeyIterator
extends DirectedIterator<Long> {
    public static AbstractDirectedLongKeyIterator getIterator(Table table, Range<Long> keyRange, DirectedIterator.Direction direction) throws IOException {
        long min = DirectedIterator.toIteratorMin(keyRange);
        long max = DirectedIterator.toIteratorMax(keyRange);
        if (direction == DirectedIterator.Direction.FORWARD) {
            return new ForwardLongKeyIterator(table.longKeyIterator(min, max, min));
        }
        return new BackwardLongKeyIterator(table.longKeyIterator(min, max, max));
    }
}

