/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import com.google.common.collect.Collections2;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.AddressRangeIterators;
import ghidra.util.ComparatorMath;
import java.util.Arrays;
import java.util.Collection;

public class UnionAddressSetView
extends AbstractAddressSetView {
    private final Collection<AddressSetView> views;

    public UnionAddressSetView(AddressSetView ... views) {
        this(Arrays.asList(views));
    }

    public UnionAddressSetView(Collection<AddressSetView> views) {
        this.views = views;
    }

    public boolean contains(Address addr) {
        for (AddressSetView v : this.views) {
            if (!v.contains(addr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (AddressSetView v : this.views) {
            if (v.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Address getMinAddress() {
        Address result = null;
        for (AddressSetView v : this.views) {
            Address candMin = v.getMinAddress();
            if (candMin == null) continue;
            if (result == null) {
                result = candMin;
                continue;
            }
            result = ComparatorMath.cmin(result, candMin);
        }
        return result;
    }

    @Override
    public Address getMaxAddress() {
        Address result = null;
        for (AddressSetView v : this.views) {
            Address candMin = v.getMaxAddress();
            if (candMin == null) continue;
            if (result == null) {
                result = candMin;
                continue;
            }
            result = ComparatorMath.cmax(result, candMin);
        }
        return result;
    }

    public AddressRangeIterator getAddressRanges() {
        return AddressRangeIterators.union(Collections2.transform(this.views, v -> v.iterator()), true);
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return AddressRangeIterators.union(Collections2.transform(this.views, v -> v.iterator(forward)), forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        AddressRangeIterator rev = AddressRangeIterators.union(Collections2.transform(this.views, v -> v.iterator(start, !forward)), !forward);
        Address fixedStart = UnionAddressSetView.fixStart(rev, start, forward);
        return AddressRangeIterators.union(Collections2.transform(this.views, v -> v.iterator(fixedStart, forward)), forward);
    }
}

