/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AssignStmt;
import ghidra.pcode.struct.CallExpr;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.pcode.struct.VoidExprStmt;
import ghidra.program.model.data.DataType;
import java.util.List;

public class DefaultUseropDecl
implements StructuredSleigh.UseropDecl {
    private final StructuredSleigh ctx;
    private final DataType retType;
    private final String name;
    private final List<DataType> paramTypes;

    public DefaultUseropDecl(StructuredSleigh ctx, DataType retType, String name, List<DataType> paramTypes) {
        this.ctx = ctx;
        this.retType = retType;
        this.name = name;
        this.paramTypes = List.copyOf(paramTypes);
    }

    @Override
    public DataType getReturnType() {
        return this.retType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<DataType> getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public StructuredSleigh.StmtWithVal call(StructuredSleigh.RVal ... args) {
        if (this.paramTypes.size() != args.length) {
            this.ctx.emitParameterCountMismatch(this, List.of(args));
        }
        for (int i = 0; i < args.length && i < this.paramTypes.size(); ++i) {
            StructuredSleigh.RVal a;
            DataType pType = this.paramTypes.get(i);
            if (this.ctx.isAssignable(pType, (a = args[i]).getType())) continue;
            this.ctx.emitParameterTypeMismatch(this, i, a);
        }
        if (this.retType.getLength() == 0) {
            return new VoidExprStmt(this.ctx, new CallExpr(this.ctx, this, List.of(args)));
        }
        return new AssignStmt(this.ctx, this.ctx.temp(this.retType), new CallExpr(this.ctx, this, List.of(args)));
    }
}

