/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.SleighLinkException;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.List;
import java.util.Map;

public class PcodeExecutor<T> {
    protected final SleighLanguage language;
    protected final PcodeArithmetic<T> arithmetic;
    protected final PcodeExecutorState<T> state;
    protected final PcodeExecutorStatePiece.Reason reason;
    protected final Register pc;
    protected final int pointerSize;

    public PcodeExecutor(SleighLanguage language, PcodeArithmetic<T> arithmetic, PcodeExecutorState<T> state, PcodeExecutorStatePiece.Reason reason) {
        this.language = language;
        this.arithmetic = arithmetic;
        this.state = state;
        this.reason = reason;
        this.pc = language.getProgramCounter();
        this.pointerSize = language.getDefaultSpace().getPointerSize();
    }

    public SleighLanguage getLanguage() {
        return this.language;
    }

    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    public PcodeExecutorState<T> getState() {
        return this.state;
    }

    public PcodeExecutorStatePiece.Reason getReason() {
        return this.reason;
    }

    public void executeSleigh(String source) {
        PcodeProgram program = SleighProgramCompiler.compileProgram(this.language, "exec", source, PcodeUseropLibrary.NIL);
        this.execute(program, PcodeUseropLibrary.nil());
    }

    public PcodeFrame begin(PcodeProgram program) {
        return this.begin(program.code, program.useropNames);
    }

    public PcodeFrame execute(PcodeProgram program, PcodeUseropLibrary<T> library) {
        return this.execute(program.code, program.useropNames, library);
    }

    public PcodeFrame begin(List<PcodeOp> code, Map<Integer, String> useropNames) {
        return new PcodeFrame((Language)this.language, code, useropNames);
    }

    public PcodeFrame execute(List<PcodeOp> code, Map<Integer, String> useropNames, PcodeUseropLibrary<T> library) {
        PcodeFrame frame = this.begin(code, useropNames);
        this.finish(frame, library);
        return frame;
    }

    public void finish(PcodeFrame frame, PcodeUseropLibrary<T> library) {
        try {
            while (!frame.isFinished()) {
                this.step(frame, library);
            }
        }
        catch (PcodeExecutionException e) {
            if (e.frame == null) {
                e.frame = frame;
            }
            throw e;
        }
    }

    protected void badOp(PcodeOp op) {
        switch (op.getOpcode()) {
            case 0: {
                throw new LowlevelError("Encountered an unimplemented instruction at " + op.getSeqnum().getTarget());
            }
        }
        throw new LowlevelError("Unsupported p-code op at " + op.getSeqnum().getTarget() + ": " + op);
    }

    public void stepOp(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<T> library) {
        OpBehavior b = OpBehaviorFactory.getOpBehavior((int)op.getOpcode());
        if (b == null) {
            this.badOp(op);
            return;
        }
        if (b instanceof UnaryOpBehavior) {
            this.executeUnaryOp(op, (UnaryOpBehavior)b);
            return;
        }
        if (b instanceof BinaryOpBehavior) {
            this.executeBinaryOp(op, (BinaryOpBehavior)b);
            return;
        }
        switch (op.getOpcode()) {
            case 2: {
                this.executeLoad(op);
                return;
            }
            case 3: {
                this.executeStore(op);
                return;
            }
            case 4: {
                this.executeBranch(op, frame);
                return;
            }
            case 5: {
                this.executeConditionalBranch(op, frame);
                return;
            }
            case 6: {
                this.executeIndirectBranch(op, frame);
                return;
            }
            case 7: {
                this.executeCall(op, frame);
                return;
            }
            case 8: {
                this.executeIndirectCall(op, frame);
                return;
            }
            case 9: {
                this.executeCallother(op, frame, library);
                return;
            }
            case 10: {
                this.executeReturn(op, frame);
                return;
            }
        }
        this.badOp(op);
    }

    public void step(PcodeFrame frame, PcodeUseropLibrary<T> library) {
        try {
            this.stepOp(frame.nextOp(), frame, library);
        }
        catch (PcodeExecutionException e) {
            e.frame = frame;
            throw e;
        }
        catch (Exception e) {
            throw new PcodeExecutionException("Exception during pcode execution", frame, e);
        }
    }

    public void skip(PcodeFrame frame) {
        frame.nextOp();
    }

    protected int getIntConst(Varnode vn) {
        assert (vn.getAddress().getAddressSpace().isConstantSpace());
        return (int)vn.getAddress().getOffset();
    }

    public void executeUnaryOp(PcodeOp op, UnaryOpBehavior b) {
        Varnode in1Var = op.getInput(0);
        Varnode outVar = op.getOutput();
        Object in1 = this.state.getVar(in1Var, this.reason);
        T out = this.arithmetic.unaryOp(op, in1);
        this.state.setVar(outVar, out);
    }

    public void executeBinaryOp(PcodeOp op, BinaryOpBehavior b) {
        Varnode in1Var = op.getInput(0);
        Varnode in2Var = op.getInput(1);
        Varnode outVar = op.getOutput();
        Object in1 = this.state.getVar(in1Var, this.reason);
        Object in2 = this.state.getVar(in2Var, this.reason);
        T out = this.arithmetic.binaryOp(op, in1, in2);
        this.state.setVar(outVar, out);
    }

    public void executeLoad(PcodeOp op) {
        int spaceID = this.getIntConst(op.getInput(0));
        AddressSpace space = this.language.getAddressFactory().getAddressSpace(spaceID);
        Varnode inOffset = op.getInput(1);
        Object offset = this.state.getVar(inOffset, this.reason);
        Varnode outvar = op.getOutput();
        Object out = this.state.getVar(space, offset, outvar.getSize(), true, this.reason);
        T mod = this.arithmetic.modAfterLoad(outvar.getSize(), inOffset.getSize(), offset, outvar.getSize(), out);
        this.state.setVar(outvar, mod);
    }

    public void executeStore(PcodeOp op) {
        int spaceID = this.getIntConst(op.getInput(0));
        AddressSpace space = this.language.getAddressFactory().getAddressSpace(spaceID);
        Varnode inOffset = op.getInput(1);
        Object offset = this.state.getVar(inOffset, this.reason);
        Varnode valVar = op.getInput(2);
        Object val = this.state.getVar(valVar, this.reason);
        T mod = this.arithmetic.modBeforeStore(valVar.getSize(), inOffset.getSize(), offset, valVar.getSize(), val);
        this.state.setVar(space, offset, valVar.getSize(), true, mod);
    }

    protected void branchToAddress(Address target) {
    }

    protected void branchToOffset(T offset, PcodeFrame frame) {
        this.state.setVar(this.pc, offset);
        frame.finishAsBranch();
    }

    protected void doExecuteBranch(PcodeOp op, PcodeFrame frame) {
        Address target = op.getInput(0).getAddress();
        if (target.isConstantAddress()) {
            frame.branch((int)target.getOffset());
        } else {
            this.branchToOffset(this.arithmetic.fromConst(target.getOffset(), this.pointerSize), frame);
            this.branchToAddress(target);
        }
    }

    public void executeBranch(PcodeOp op, PcodeFrame frame) {
        this.doExecuteBranch(op, frame);
    }

    public void executeConditionalBranch(PcodeOp op, PcodeFrame frame) {
        Varnode condVar = op.getInput(1);
        Object cond = this.state.getVar(condVar, this.reason);
        if (this.arithmetic.isTrue(cond, PcodeArithmetic.Purpose.CONDITION)) {
            this.doExecuteBranch(op, frame);
        }
    }

    protected void doExecuteIndirectBranch(PcodeOp op, PcodeFrame frame) {
        Object offset = this.state.getVar(op.getInput(0), this.reason);
        this.branchToOffset(offset, frame);
        long concrete = this.arithmetic.toLong(offset, PcodeArithmetic.Purpose.BRANCH);
        Address target = op.getSeqnum().getTarget().getNewAddress(concrete, true);
        this.branchToAddress(target);
    }

    public void executeIndirectBranch(PcodeOp op, PcodeFrame frame) {
        this.doExecuteIndirectBranch(op, frame);
    }

    public void executeCall(PcodeOp op, PcodeFrame frame) {
        Address target = op.getInput(0).getAddress();
        this.branchToOffset(this.arithmetic.fromConst(target.getOffset(), this.pointerSize), frame);
        this.branchToAddress(target);
    }

    public void executeIndirectCall(PcodeOp op, PcodeFrame frame) {
        this.doExecuteIndirectBranch(op, frame);
    }

    public String getUseropName(int opNo, PcodeFrame frame) {
        if (opNo < this.language.getNumberOfUserDefinedOpNames()) {
            return this.language.getUserDefinedOpName(opNo);
        }
        return frame.getUseropName(opNo);
    }

    public void executeCallother(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<T> library) {
        int opNo = this.getIntConst(op.getInput(0));
        String opName = this.getUseropName(opNo, frame);
        if (opName == null) {
            throw new AssertionError((Object)("Pcode userop " + opNo + " is not defined"));
        }
        PcodeUseropLibrary.PcodeUseropDefinition<T> opDef = library.getUserops().get(opName);
        if (opDef != null) {
            opDef.execute(this, library, op.getOutput(), List.of(op.getInputs()).subList(1, op.getNumInputs()));
            return;
        }
        this.onMissingUseropDef(op, frame, opName, library);
    }

    protected void onMissingUseropDef(PcodeOp op, PcodeFrame frame, String opName, PcodeUseropLibrary<T> library) {
        throw new SleighLinkException("Sleigh userop '" + opName + "' is not in the library " + library);
    }

    public void executeReturn(PcodeOp op, PcodeFrame frame) {
        this.doExecuteIndirectBranch(op, frame);
    }
}

