/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.DockingWindowManager;
import docking.Tool;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import java.util.function.Function;

public final class PluginToolUtils
extends Enum<PluginToolUtils> {
    private static final /* synthetic */ PluginToolUtils[] $VALUES;

    public static PluginToolUtils[] values() {
        return (PluginToolUtils[])$VALUES.clone();
    }

    public static PluginToolUtils valueOf(String name) {
        return Enum.valueOf(PluginToolUtils.class, name);
    }

    public static <T> T inRunningToolsPreferringActive(PluginTool tool, Function<? super PluginTool, ? extends T> action) {
        PluginTool activePluginTool;
        T result;
        Tool activeTool = DockingWindowManager.getActiveInstance().getTool();
        if (activeTool instanceof PluginTool && (result = action.apply((PluginTool)(activePluginTool = (PluginTool)activeTool))) != null) {
            return result;
        }
        for (PluginTool pt : tool.getToolServices().getRunningTools()) {
            T result2 = action.apply((PluginTool)pt);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static PluginTool openInMostRecentOrLaunchedCompatibleTool(PluginTool tool, DomainFile domainFile) {
        DomainFile[] data = new DomainFile[]{domainFile};
        PluginTool result = PluginToolUtils.inRunningToolsPreferringActive(tool, pt -> pt.acceptDomainFiles(data) ? pt : null);
        if (result != null) {
            return result;
        }
        return tool.getToolServices().launchDefaultTool(domainFile);
    }

    public static <T> T getServiceFromRunningCompatibleTool(PluginTool tool, Class<T> serviceClass) {
        return (T)PluginToolUtils.inRunningToolsPreferringActive(tool, pt -> pt.getService(serviceClass));
    }

    private static /* synthetic */ PluginToolUtils[] $values() {
        return new PluginToolUtils[0];
    }

    static {
        $VALUES = PluginToolUtils.$values();
    }
}

