/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Unique {
    public static <T> T assertOne(Iterable<T> col) {
        Iterator<T> it = col.iterator();
        if (!it.hasNext()) {
            throw new AssertionError((Object)"Expected exactly one. Got none.");
        }
        T result = it.next();
        if (it.hasNext()) {
            ArrayList<T> all = new ArrayList<T>();
            all.add(result);
            while (it.hasNext()) {
                all.add(it.next());
            }
            throw new AssertionError((Object)("Expected exactly one. Got many: " + all));
        }
        return result;
    }

    public static <T> T assertOne(Stream<T> st) {
        return Unique.assertOne(st.collect(Collectors.toList()));
    }

    public static <T> T assertAtMostOne(Iterable<T> col) {
        Iterator<T> it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T result = it.next();
        if (it.hasNext()) {
            throw new AssertionError((Object)"Expected at most one. Got many.");
        }
        return result;
    }
}

