/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb;

import agent.gdb.GdbCompatibility;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.pty.PtyFactory;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.ShellUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="IN-VM GNU gdb local debugger", htmlDetails="Launch a GDB session in this same JVM")
public class GdbInJvmDebuggerModelFactory
implements DebuggerModelFactory {
    private String gdbCmd = "/usr/bin/gdb";
    @ConfigurableFactory.FactoryOption(value="GDB launch command")
    public final ConfigurableFactory.Property<String> gdbCommandOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getGdbCommand, this::setGdbCommand);
    private boolean existing = false;
    @ConfigurableFactory.FactoryOption(value="Use existing session via new-ui")
    public final ConfigurableFactory.Property<Boolean> useExistingOption = ConfigurableFactory.Property.fromAccessors(Boolean.TYPE, this::isUseExisting, this::setUseExisting);

    public CompletableFuture<? extends DebuggerObjectModel> build() {
        List gdbCmdLine = ShellUtils.parseArgs((String)this.gdbCmd);
        GdbModelImpl model = new GdbModelImpl(PtyFactory.local());
        return model.startGDB(this.existing ? null : (String)gdbCmdLine.get(0), (String[])gdbCmdLine.subList(1, gdbCmdLine.size()).toArray(String[]::new)).thenApply(__ -> model);
    }

    public boolean isCompatible() {
        return GdbCompatibility.INSTANCE.isCompatible(this.gdbCmd);
    }

    public String getGdbCommand() {
        return this.gdbCmd;
    }

    public void setGdbCommand(String gdbCmd) {
        this.gdbCmd = gdbCmd;
    }

    public boolean isUseExisting() {
        return this.existing;
    }

    public void setUseExisting(boolean existing) {
        this.existing = existing;
        this.gdbCommandOption.setEnabled(!existing);
    }
}

