/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.model.iface1.DbgModelTargetFocusScope;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetStack;
import agent.dbgeng.model.iface2.DbgModelTargetStackFrame;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetThreadImpl;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="StackFrame", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="function", type=String.class), @TargetAttributeType(name="Table Entry", type=String.class), @TargetAttributeType(name="Inst. Offset", type=Address.class), @TargetAttributeType(name="Frame Offset", type=Address.class), @TargetAttributeType(name="Return Offset", type=Address.class), @TargetAttributeType(name="Stack Offset", type=Address.class), @TargetAttributeType(name="Virtual", type=Boolean.class), @TargetAttributeType(name="Param[0]", type=String.class), @TargetAttributeType(name="Param[1]", type=String.class), @TargetAttributeType(name="Param[2]", type=String.class), @TargetAttributeType(name="Param[3]", type=String.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetStackFrameImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetStackFrame {
    protected final DbgModelTargetThread thread;
    protected DbgStackFrame frame;
    protected Address pc;
    protected String func;
    protected String display;
    private Long funcTableEntry = -1L;
    private Long frameOffset = -1L;
    private Long returnOffset = -1L;
    private Long stackOffset = -1L;
    private Boolean virtual = false;
    private long[] params = new long[4];

    protected static String indexFrame(DbgStackFrame frame) {
        return PathUtils.makeIndex((int)frame.getLevel());
    }

    protected static String keyFrame(DbgStackFrame frame) {
        return PathUtils.makeKey((String)DbgModelTargetStackFrameImpl.indexFrame(frame));
    }

    public DbgModelTargetStackFrameImpl(DbgModelTargetStack stack, DbgModelTargetThread thread, DbgStackFrame frame) {
        super(stack.getModel(), (TargetObject)stack, DbgModelTargetStackFrameImpl.keyFrame(frame), "StackFrame");
        this.getModel().addModelObject(frame, (TargetObject)this);
        this.thread = thread;
        this.pc = this.getModel().getAddressSpace("ram").getAddress(-1L);
        this.display = DbgModelTargetStackFrameImpl.computeDisplay(frame);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.display, "_pc", this.pc), "Initialized");
        this.setFrame(frame);
        this.getManager().addEventsListener(this);
    }

    protected static String computeDisplay(DbgStackFrame frame) {
        if (frame.getFunction() == null) {
            return String.format("#%d 0x%s", frame.getLevel(), frame.getAddress().toString(16));
        }
        return String.format("#%d 0x%s in %s ()", frame.getLevel(), frame.getAddress().toString(16), frame.getFunction());
    }

    @Override
    public void threadSelected(DbgThread eventThread, DbgStackFrame eventFrame, DbgCause cause) {
        if (eventFrame != null && eventFrame.equals(this.frame)) {
            ((DbgModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public void setFrame(DbgStackFrame frame) {
        BigInteger address = frame.getAddress();
        long lval = address == null ? -1L : address.longValue();
        this.pc = this.getModel().getAddressSpace("ram").getAddress(lval);
        this.func = frame.getFunction();
        if (this.func == null) {
            this.func = "UNKNOWN";
        }
        this.funcTableEntry = frame.getFuncTableEntry();
        this.frameOffset = frame.getFrameOffset();
        this.returnOffset = frame.getReturnOffset();
        this.stackOffset = frame.getStackOffset();
        this.virtual = frame.getVirtual();
        this.params = frame.getParams();
        this.frame = frame;
        AddressSpace space = this.getModel().getAddressSpace("ram");
        this.display = DbgModelTargetStackFrameImpl.computeDisplay(frame);
        this.changeAttributes(List.of(), List.of(), Map.of("_pc", this.pc, "_display", this.display, "function", this.func, "Table Entry", Long.toHexString(this.funcTableEntry), "Inst. Offset", space.getAddress(lval), "Frame Offset", space.getAddress(this.frameOffset.longValue()), "Return Offset", space.getAddress(this.returnOffset.longValue()), "Stack Offset", space.getAddress(this.stackOffset.longValue()), "Virtual", this.virtual), "Refreshed");
        this.changeAttributes(List.of(), List.of(), Map.of("Param[0]", Long.toHexString(this.params[0]), "Param[1]", Long.toHexString(this.params[1]), "Param[2]", Long.toHexString(this.params[2]), "Param[3]", Long.toHexString(this.params[3])), "Refreshed");
    }

    @Override
    public TargetObject getThread() {
        return this.thread.getParent();
    }

    @Override
    public Address getPC() {
        return this.pc;
    }

    @Override
    public DbgModelTargetProcess getProcess() {
        return ((DbgModelTargetThreadImpl)this.thread).getProcess();
    }
}

