/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.nio.ByteBuffer;

public class DbgReadDebuggerDataCommand
extends AbstractDbgCommand<RangeSet<Long>> {
    private final long addr;
    private final ByteBuffer buf;
    private final int len;
    private int readLen;

    public DbgReadDebuggerDataCommand(DbgManagerImpl manager, long addr, ByteBuffer buf, int len) {
        super(manager);
        this.addr = addr;
        this.buf = buf;
        this.len = len;
    }

    @Override
    public RangeSet<Long> complete(DbgPendingCommand<?> pending) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Long.valueOf(this.addr), (Comparable)Long.valueOf(this.addr + (long)this.readLen)));
        return rangeSet;
    }

    @Override
    public void invoke() {
        this.readLen = this.manager.getDataSpaces().readDebuggerData((int)this.addr, this.buf, this.len);
    }
}

