/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.util.image.ToolIconURL;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.jdom.Content;
import org.jdom.Element;

public class GhidraToolTemplate
implements ToolTemplate {
    private static final String CLASS_NAME_XML_NAME = "CLASS_NAME";
    private static final String LOCATION_XML_NAME = "LOCATION";
    private static final String ICON_XML_NAME = "ICON";
    public static String TEMPLATE_NAME = "Ghidra_Tool_Template";
    private Class<?>[] supportedDataTypes;
    private Element toolElement;
    private ToolIconURL iconURL;
    private String path;

    public GhidraToolTemplate(Element root, String path) {
        this.path = path;
        this.restoreFromXml(root);
    }

    public GhidraToolTemplate(ToolIconURL iconURL, Element toolElement, Class<?>[] supportedDataTypes) {
        this.iconURL = iconURL;
        this.toolElement = toolElement;
        this.supportedDataTypes = supportedDataTypes;
    }

    @Override
    public String getName() {
        return this.toolElement.getAttributeValue("TOOL_NAME");
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setName(String name) {
        this.toolElement.setAttribute("TOOL_NAME", name);
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconURL.getIcon();
    }

    @Override
    public Class<?>[] getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @Override
    public ToolIconURL getIconURL() {
        return this.iconURL;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GhidraToolTemplate otherTemplate = (GhidraToolTemplate)obj;
        if (this.hashCode() != otherTemplate.hashCode()) {
            return false;
        }
        return this.getName().equals(otherTemplate.getName());
    }

    public String toString() {
        return this.getName() + " - " + this.path;
    }

    @Override
    public void restoreFromXml(Element root) {
        List list = root.getChildren("SUPPORTED_DATA_TYPE");
        ArrayList dtList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Element elem = (Element)list.get(i);
            String className = elem.getAttribute(CLASS_NAME_XML_NAME).getValue();
            try {
                dtList.add(Class.forName(className));
                continue;
            }
            catch (ClassNotFoundException e) {
                Msg.error((Object)this, (Object)("Class not found: " + className), (Throwable)e);
                continue;
            }
            catch (Exception exc) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + exc.getMessage()), (Throwable)exc);
            }
        }
        this.supportedDataTypes = new Class[dtList.size()];
        dtList.toArray(this.supportedDataTypes);
        Element iconElem = root.getChild(ICON_XML_NAME);
        String location = iconElem.getAttributeValue(LOCATION_XML_NAME);
        String iconText = iconElem.getText();
        if (iconText != null && iconText.length() > 0) {
            iconText = iconText.trim();
            byte[] imageBytes = NumericUtilities.convertStringToBytes((String)iconText);
            this.iconURL = new ToolIconURL(location, imageBytes);
        } else {
            this.iconURL = new ToolIconURL(location);
        }
        this.toolElement = root.getChild("TOOL");
    }

    @Override
    public Element saveToXml() {
        Element root = new Element("TOOL_CONFIG");
        root.setAttribute("CONFIG_NAME", "NO_LONGER_USED");
        for (Class<?> supportedDataType : this.supportedDataTypes) {
            Element elem = new Element("SUPPORTED_DATA_TYPE");
            elem.setAttribute(CLASS_NAME_XML_NAME, supportedDataType.getName());
            root.addContent((Content)elem);
        }
        Element iconElem = new Element(ICON_XML_NAME);
        iconElem.setAttribute(LOCATION_XML_NAME, this.iconURL.getLocation());
        if (this.iconURL.getIconBytes() != null) {
            iconElem.setText(NumericUtilities.convertBytesToString((byte[])this.iconURL.getIconBytes()));
        }
        root.addContent((Content)iconElem);
        root.addContent((Content)((Element)this.toolElement.clone()));
        return root;
    }

    public void setIconURL(ToolIconURL url) {
        this.iconURL = url;
    }

    @Override
    public Element getToolElement() {
        return this.toolElement;
    }

    @Override
    public PluginTool createTool(Project project) {
        return new GhidraTool(project, this);
    }
}

