/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import resources.ResourceManager;

public class DomainFileNode
extends GTreeNode
implements Cuttable {
    private static final Icon UNKNOWN_FILE_ICON = ResourceManager.loadImage((String)"images/unknownFile.gif");
    private final DomainFile domainFile;
    private volatile String displayName;
    private volatile Icon icon = UNKNOWN_FILE_ICON;
    private volatile Icon disabledIcon;
    protected volatile String toolTipText;
    private volatile boolean isCut;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy MMM dd hh:mm aaa");

    DomainFileNode(DomainFile domainFile) {
        this.domainFile = domainFile;
        this.displayName = domainFile.getName();
        this.refresh();
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainFileNode node = (DomainFileNode)obj;
        return this.domainFile == node.domainFile;
    }

    public int hashCode() {
        return System.identityHashCode(this.domainFile);
    }

    @Override
    public void setIsCut(boolean isCut) {
        this.isCut = isCut;
        this.fireNodeChanged(this.getParent(), this);
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    public boolean isEditable() {
        return this.domainFile.isInWritableProject();
    }

    public Icon getIcon(boolean expanded) {
        if (this.isCut) {
            return this.disabledIcon;
        }
        return this.icon;
    }

    public String getName() {
        return this.domainFile.getName();
    }

    void setName(String newName) {
        try {
            this.domainFile.setName(newName);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Set Name Failed", (Object)e.getMessage());
        }
    }

    public String getDisplayText() {
        return this.displayName;
    }

    void refresh() {
        DomainFileNodeSwingWorker worker = new DomainFileNodeSwingWorker();
        worker.execute();
    }

    private void doRefresh() {
        String name = this.domainFile.getName();
        Object newDisplayName = name;
        if (this.domainFile.isHijacked()) {
            newDisplayName = (String)newDisplayName + " (hijacked)";
        } else if (this.domainFile.isVersioned()) {
            int versionNumber = this.domainFile.getVersion();
            Object versionStr = "" + versionNumber;
            if (versionNumber < 0) {
                versionStr = "?";
            }
            if (this.domainFile.isCheckedOut()) {
                int latestVersionNumber = this.domainFile.getLatestVersion();
                Object latestVersionStr = "" + latestVersionNumber;
                if (latestVersionNumber < 0) {
                    latestVersionStr = "?";
                }
                newDisplayName = (String)newDisplayName + " (" + (String)versionStr + " of " + (String)latestVersionStr + ")";
                if (this.domainFile.modifiedSinceCheckout()) {
                    newDisplayName = (String)newDisplayName + "*";
                }
            } else {
                newDisplayName = (String)newDisplayName + " (" + (String)versionStr + ")";
            }
        }
        this.displayName = newDisplayName;
        this.setToolTipText();
        this.icon = this.domainFile.getIcon(false);
        this.disabledIcon = ResourceManager.getDisabledIcon((Icon)this.icon);
        this.fireNodeChanged(this.getParent(), this);
    }

    private void setToolTipText() {
        Object newToolTipText = this.toolTipText;
        if (this.domainFile.isInWritableProject() && this.domainFile.isHijacked()) {
            newToolTipText = "Hijacked file should be deleted or renamed";
        } else {
            long lastModified = this.domainFile.getLastModifiedTime();
            newToolTipText = "Last Modified " + this.formatter.format(new Date(lastModified));
            if (this.domainFile.isCheckedOut()) {
                try {
                    ItemCheckoutStatus status = this.domainFile.getCheckoutStatus();
                    if (status != null) {
                        newToolTipText = HTMLUtilities.toHTML((String)("Checked out " + this.formatter.format(new Date(status.getCheckoutTime())) + ";\n" + (String)newToolTipText));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.domainFile.isReadOnly()) {
                newToolTipText = (String)newToolTipText + " (read only)";
            }
        }
        this.toolTipText = newToolTipText;
    }

    public String getToolTip() {
        return this.toolTipText;
    }

    public int compareTo(GTreeNode node) {
        if (node instanceof DomainFolderNode) {
            return 1;
        }
        return super.compareTo(node);
    }

    public void valueChanged(Object newValue) {
        if (newValue.equals(this.getName())) {
            return;
        }
        if (newValue instanceof String) {
            try {
                this.domainFile.setName((String)newValue);
            }
            catch (InvalidNameException | DuplicateFileException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)("Invalid name: " + e.getMessage()));
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)("There was a problem renaming the file:\n" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    private class DomainFileNodeSwingWorker
    extends SwingWorker<DomainFileNode, Object> {
        private DomainFileNodeSwingWorker() {
        }

        @Override
        protected DomainFileNode doInBackground() throws Exception {
            DomainFileNode.this.doRefresh();
            return DomainFileNode.this;
        }
    }
}

