/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.timer.GhidraSwinglessTimer;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.data.DomainFileIndex;
import ghidra.framework.data.DomainFolderChangeListenerList;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.data.GhidraFolder;
import ghidra.framework.data.GhidraFolderData;
import ghidra.framework.data.RootGhidraFolderData;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.remote.User;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FileSystemListener;
import ghidra.framework.store.FileSystemSynchronizer;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.framework.store.remote.RemoteFileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.PropertyFile;
import ghidra.util.ReadOnlyException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utilities.util.FileUtilities;

public class ProjectFileManager
implements ProjectData {
    public static final String MANGLED_DATA_FOLDER_NAME = "data";
    public static final String INDEXED_DATA_FOLDER_NAME = "idata";
    public static final String USER_FOLDER_NAME = "user";
    public static final String VERSIONED_FOLDER_NAME = "versioned";
    private static final String USER_DATA_FILE_PREFIX = "udf_";
    private static final String TEST_REPOSITORY_PATH = System.getProperty("Repository");
    private static final String SERVER_NAME = "SERVER";
    private static final String PORT_NUMBER = "PORT_NUMBER";
    private static final String REPOSITORY_NAME = "REPOSITORY_NAME";
    private static final String OWNER = "OWNER";
    private static final String PROPERTY_FILENAME = "project";
    private static final int USER_DATA_RECONCILE_DELAY_MS = 300000;
    private GhidraSwinglessTimer userDataReconcileTimer;
    private Thread userDataReconcileThread;
    private ProjectLocator localStorageLocator;
    private File projectDir;
    private PropertyFile properties;
    private LocalFileSystem fileSystem;
    private FileSystem versionedFileSystem;
    private LocalFileSystem userFileSystem;
    private MyFileSystemListener versionedFSListener;
    private RepositoryAdapter repository;
    private DomainFileIndex fileIndex = new DomainFileIndex(this);
    private DomainFolderChangeListenerList listenerList = new DomainFolderChangeListenerList(this.fileIndex);
    private RootGhidraFolderData rootFolderData;
    private Map<String, DomainObjectAdapter> openDomainObjects = new HashMap<String, DomainObjectAdapter>();
    private TaskMonitorAdapter projectDisposalMonitor = new TaskMonitorAdapter();
    private String owner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFileManager(ProjectLocator localStorageLocator, boolean isInWritableProject, boolean resetOwner) throws NotOwnerException, IOException {
        this.localStorageLocator = localStorageLocator;
        this.init(false, isInWritableProject);
        if (resetOwner) {
            this.owner = SystemUtilities.getUserName();
            this.properties.putString(OWNER, this.owner);
            this.properties.writeState();
        } else if (isInWritableProject && !SystemUtilities.getUserName().equals(this.owner)) {
            if (this.owner == null) {
                throw new NotOwnerException("Older projects may only be opened as a View.\nYou must first create a new project or open an existing current project, \nthen use the \"Project->View\" menu action to open the older project as a view.\nYou can then drag old files into your active project.");
            }
            throw new NotOwnerException("Project is owned by " + this.owner);
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.getVersionedFileSystem(isInWritableProject);
            this.rootFolderData = new RootGhidraFolderData(this, this.listenerList);
            this.versionedFSListener = new MyFileSystemListener();
            this.versionedFileSystem.addFileSystemListener((FileSystemListener)this.versionedFSListener);
            this.scheduleUserDataReconcilation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFileManager(ProjectLocator localStorageLocator, RepositoryAdapter repository, boolean isInWritableProject) throws IOException {
        this.localStorageLocator = localStorageLocator;
        this.repository = repository;
        this.init(true, isInWritableProject);
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.createVersionedFileSystem();
            this.rootFolderData = new RootGhidraFolderData(this, this.listenerList);
            this.versionedFSListener = new MyFileSystemListener();
            this.versionedFileSystem.addFileSystemListener((FileSystemListener)this.versionedFSListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectFileManager(LocalFileSystem fileSystem, FileSystem versionedFileSystem) {
        this.localStorageLocator = new ProjectLocator(null, "Test");
        this.owner = SystemUtilities.getUserName();
        LocalFileSystem localFileSystem = fileSystem;
        synchronized (localFileSystem) {
            this.fileSystem = fileSystem;
            this.versionedFileSystem = versionedFileSystem;
            this.rootFolderData = new RootGhidraFolderData(this, this.listenerList);
            this.versionedFSListener = new MyFileSystemListener();
            versionedFileSystem.addFileSystemListener((FileSystemListener)this.versionedFSListener);
            this.scheduleUserDataReconcilation();
        }
    }

    private void init(boolean create, boolean isInWritableProject) throws IOException {
        this.projectDir = this.localStorageLocator.getProjectDir();
        this.properties = new PropertyFile(this.projectDir, PROPERTY_FILENAME, "/", PROPERTY_FILENAME);
        if (create) {
            if (this.projectDir.exists()) {
                throw new DuplicateFileException("Project directory already exists: " + this.projectDir.getCanonicalPath());
            }
            this.projectDir.mkdir();
            this.localStorageLocator.getMarkerFile().createNewFile();
            this.owner = SystemUtilities.getUserName();
            this.properties.putString(OWNER, this.owner);
            this.properties.writeState();
        } else {
            if (!this.projectDir.isDirectory()) {
                throw new FileNotFoundException("Project directory not found: " + this.projectDir);
            }
            if (this.properties.exists()) {
                if (isInWritableProject && this.properties.isReadOnly()) {
                    throw new ReadOnlyException("Project " + this.localStorageLocator.getName() + " is read-only");
                }
                this.properties.readState();
                this.owner = this.properties.getString(OWNER, SystemUtilities.getUserName());
            } else if (isInWritableProject) {
                this.owner = SystemUtilities.getUserName();
                this.properties.putString(OWNER, this.owner);
                this.properties.writeState();
            } else {
                this.owner = "<unknown>";
            }
        }
        this.getPrivateFileSystem(create, isInWritableProject);
        this.getUserFileSystem(isInWritableProject);
    }

    @Override
    public int getMaxNameLength() {
        return this.fileSystem.getMaxNameLength();
    }

    @Override
    public void testValidName(String name, boolean isPath) throws InvalidNameException {
        this.fileSystem.testValidName(name, isPath);
    }

    @Override
    public User getUser() {
        if (this.repository != null) {
            try {
                return this.repository.getUser();
            }
            catch (IOException e) {
                return new User(SystemUtilities.getUserName(), 0);
            }
        }
        return null;
    }

    private void createVersionedFileSystem() throws IOException {
        if (this.repository != null) {
            this.updatePropertiesFile(this.repository);
            this.versionedFileSystem = new RemoteFileSystem(this.repository);
        } else {
            File versionedFileSystemDir = new File(this.projectDir, VERSIONED_FOLDER_NAME);
            if (!versionedFileSystemDir.exists()) {
                versionedFileSystemDir.mkdir();
            }
            this.versionedFileSystem = LocalFileSystem.getLocalFileSystem((String)versionedFileSystemDir.getAbsolutePath(), (boolean)true, (boolean)true, (boolean)false, (boolean)true);
        }
    }

    private void updatePropertiesFile(RepositoryAdapter rep) throws IOException {
        ServerInfo info = rep.getServerInfo();
        if (info == null) {
            return;
        }
        this.properties.putString(SERVER_NAME, info.getServerName());
        this.properties.putString(REPOSITORY_NAME, rep.getName());
        this.properties.putInt(PORT_NUMBER, info.getPortNumber());
        this.properties.writeState();
    }

    private void getVersionedFileSystem(boolean isInWritableProject) throws IOException {
        String serverName;
        if (TEST_REPOSITORY_PATH != null) {
            File versionedFileSystemDir = new File(TEST_REPOSITORY_PATH);
            if (versionedFileSystemDir.exists()) {
                this.versionedFileSystem = LocalFileSystem.getLocalFileSystem((String)versionedFileSystemDir.getAbsolutePath(), (boolean)false, (boolean)true, (boolean)false, (boolean)true);
                return;
            }
            Msg.error((Object)this, (Object)("Test repository not found: " + TEST_REPOSITORY_PATH));
        }
        if ((serverName = this.properties.getString(SERVER_NAME, null)) == null) {
            File versionedFileSystemDir = new File(this.projectDir, VERSIONED_FOLDER_NAME);
            boolean create = false;
            if (!versionedFileSystemDir.exists()) {
                versionedFileSystemDir.mkdir();
                create = true;
            }
            this.versionedFileSystem = LocalFileSystem.getLocalFileSystem((String)versionedFileSystemDir.getAbsolutePath(), (boolean)create, (boolean)true, (!isInWritableProject ? 1 : 0) != 0, (boolean)true);
        } else {
            int port = this.properties.getInt(PORT_NUMBER, -1);
            this.repository = this.getRepositoryAdapter(serverName, port, isInWritableProject);
            this.versionedFileSystem = new RemoteFileSystem(this.repository);
        }
    }

    private RepositoryAdapter getRepositoryAdapter(String serverName, int port, boolean isInWritableProject) {
        String repositoryName = this.properties.getString(REPOSITORY_NAME, null);
        RepositoryServerAdapter rsa = ClientUtil.getRepositoryServer((String)serverName, (int)port, (boolean)isInWritableProject);
        RepositoryAdapter rep = rsa.getRepository(repositoryName);
        if (rsa.isConnected()) {
            try {
                rep.connect();
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)rep, (Exception)e, (String)"Repository Connection", null);
            }
        }
        return rep;
    }

    FileSystem getVersionedFileSystem() {
        return this.versionedFileSystem;
    }

    LocalFileSystem getUserFileSystem() {
        return this.userFileSystem;
    }

    LocalFileSystem getLocalFileSystem() {
        return this.fileSystem;
    }

    @Override
    public Class<? extends LocalFileSystem> getLocalStorageClass() {
        return this.fileSystem.getClass();
    }

    void setVersionedFileSystem(FileSystem fs) throws IOException {
        if (!fs.isVersioned()) {
            throw new IllegalArgumentException("versioned filesystem required");
        }
        this.versionedFileSystem.removeFileSystemListener((FileSystemListener)this.versionedFSListener);
        this.versionedFileSystem = fs;
        this.versionedFileSystem.addFileSystemListener((FileSystemListener)this.versionedFSListener);
        this.rootFolderData.setVersionedFileSystem(this.versionedFileSystem);
    }

    private void getPrivateFileSystem(boolean create, boolean isInWritableProject) throws IOException {
        File fileSystemDir = new File(this.projectDir, INDEXED_DATA_FOLDER_NAME);
        if (!create && !fileSystemDir.isDirectory()) {
            fileSystemDir = new File(this.projectDir, MANGLED_DATA_FOLDER_NAME);
        }
        if (!fileSystemDir.isDirectory()) {
            if (create && !fileSystemDir.exists()) {
                if (!fileSystemDir.mkdir()) {
                    throw new IOException("Failed to create project data directory: " + fileSystemDir);
                }
            } else {
                throw new IOException("Project data directory not found: " + fileSystemDir);
            }
        }
        this.fileSystem = LocalFileSystem.getLocalFileSystem((String)fileSystemDir.getAbsolutePath(), (boolean)create, (boolean)false, (!isInWritableProject ? 1 : 0) != 0, (boolean)true);
    }

    private void getUserFileSystem(boolean isInWritableProject) throws IOException {
        if (!isInWritableProject) {
            return;
        }
        File fileSystemDir = new File(this.projectDir, USER_FOLDER_NAME);
        boolean create = false;
        if (!fileSystemDir.isDirectory()) {
            if (fileSystemDir.exists() || !fileSystemDir.mkdir()) {
                throw new IOException("Failed to create project user directory: " + fileSystemDir);
            }
            create = true;
        }
        this.userFileSystem = LocalFileSystem.getLocalFileSystem((String)fileSystemDir.getAbsolutePath(), (boolean)create, (boolean)false, (!isInWritableProject ? 1 : 0) != 0, (boolean)true);
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public GhidraFolder getRootFolder() {
        return this.rootFolderData.getDomainFolder();
    }

    @Override
    public DomainFolder getFolder(String path) {
        int len = path.length();
        if (len == 0 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Absolute path must begin with '/'");
        }
        try {
            return this.getRootFolder().getFolderPathData(path).getDomainFolder();
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public int getFileCount() {
        int sharedFileCnt = 0;
        if (this.repository != null && this.repository.isConnected()) {
            sharedFileCnt = -1;
            try {
                if (this.repository != null && this.repository.isConnected()) {
                    sharedFileCnt = this.versionedFileSystem.getItemCount();
                }
            }
            catch (Exception e) {
                return -1;
            }
        }
        int privateFileCnt = -1;
        try {
            privateFileCnt = this.fileSystem.getItemCount();
        }
        catch (Exception e) {
            return -1;
        }
        if (privateFileCnt <= 0) {
            return sharedFileCnt;
        }
        if (sharedFileCnt <= 0) {
            return privateFileCnt;
        }
        return Math.max(sharedFileCnt, privateFileCnt);
    }

    @Override
    public DomainFile getFile(String path) {
        int len = path.length();
        if (len == 0 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Absolute path must begin with '/'");
        }
        if (path.charAt(len - 1) == '/') {
            throw new IllegalArgumentException("Missing file name in path");
        }
        int ix = path.lastIndexOf(FileSystem.SEPARATOR);
        DomainFolder folder = ix > 0 ? this.getFolder(path.substring(0, ix)) : this.getRootFolder();
        if (folder != null) {
            return folder.getFile(path.substring(ix + 1));
        }
        return null;
    }

    @Override
    public DomainFile getFileByID(String fileID) {
        return this.fileIndex.getFileByID(fileID);
    }

    @Override
    public URL getSharedFileURL(String path) {
        DomainFile df;
        if (this.repository != null && (df = this.getFile(path)) != null && df.isVersioned()) {
            ServerInfo server = this.repository.getServerInfo();
            return GhidraURL.makeURL(server.getServerName(), server.getPortNumber(), this.repository.getName(), path);
        }
        return null;
    }

    public void releaseDomainFiles(Object consumer) {
        for (DomainObjectAdapter domainObj : this.openDomainObjects.values()) {
            try {
                if (!domainObj.getConsumerList().contains(consumer)) continue;
                domainObj.release(consumer);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    public void findOpenFiles(List<DomainFile> list) {
        for (DomainObjectAdapter domainObj : this.openDomainObjects.values()) {
            list.add(domainObj.getDomainFile());
        }
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.localStorageLocator;
    }

    @Override
    public void addDomainFolderChangeListener(DomainFolderChangeListener l) {
        this.listenerList.addListener(l);
    }

    @Override
    public void removeDomainFolderChangeListener(DomainFolderChangeListener l) {
        this.listenerList.removeListener(l);
    }

    public FileSystem getPrivateFileSystem() {
        return this.fileSystem;
    }

    @Override
    public RepositoryAdapter getRepository() {
        return this.repository;
    }

    @Override
    public void refresh(boolean force) throws IOException {
        try {
            this.rootFolderData.refresh(true, true, (TaskMonitor)this.projectDisposalMonitor);
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Project Refresh", null);
        }
    }

    @Override
    public void convertProjectToShared(RepositoryAdapter newRepository, TaskMonitor monitor) throws IOException, CancelledException {
        newRepository.connect();
        if (!newRepository.isConnected()) {
            throw new IOException("new respository not connected");
        }
        if (this.repository != null) {
            throw new IllegalStateException("Only private project may be converted to shared");
        }
        this.convertFilesToPrivate(this.getRootFolder(), monitor);
        this.updatePropertiesFile(newRepository);
        this.versionedFileSystem.dispose();
        this.repository = newRepository;
        this.versionedFileSystem = new RemoteFileSystem(newRepository);
        File versionedFileSystemDir = new File(this.projectDir, VERSIONED_FOLDER_NAME);
        FileUtilities.deleteDir((File)versionedFileSystemDir);
    }

    @Override
    public void updateRepositoryInfo(RepositoryAdapter newRepository, TaskMonitor monitor) throws IOException, CancelledException {
        this.findCheckedOutFiles(this.getRootFolder(), monitor);
        this.updatePropertiesFile(newRepository);
    }

    private void findCheckedOutFiles(DomainFolder folder, TaskMonitor monitor) throws IOException, CancelledException {
        DomainFolder[] folders;
        DomainFile[] files;
        for (DomainFile file : files = folder.getFiles()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            if (!file.isCheckedOut()) continue;
            throw new IOException("File " + file.getPathname() + " is checked out.");
        }
        for (DomainFolder folder2 : folders = folder.getFolders()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.findCheckedOutFiles(folder2, monitor);
        }
    }

    private void convertFilesToPrivate(DomainFolder folder, TaskMonitor monitor) throws IOException, CancelledException {
        DomainFolder[] folders;
        DomainFile[] files;
        for (DomainFile file : files = folder.getFiles()) {
            ((GhidraFile)file).convertToPrivateFile(monitor);
        }
        for (DomainFolder folder2 : folders = folder.getFolders()) {
            this.convertFilesToPrivate(folder2, monitor);
        }
    }

    public static String getUserDataFilename(String associatedFileID) {
        return USER_DATA_FILE_PREFIX + associatedFileID;
    }

    private synchronized void scheduleUserDataReconcilation() {
        boolean notOnline;
        if (this.userFileSystem == null || SystemUtilities.isInHeadlessMode()) {
            return;
        }
        boolean bl = notOnline = !this.versionedFileSystem.isOnline();
        if (this.userDataReconcileTimer != null) {
            if (notOnline) {
                this.userDataReconcileTimer.stop();
                Thread t = this.userDataReconcileThread;
                if (t != null) {
                    t.interrupt();
                }
            }
            return;
        }
        if (notOnline) {
            return;
        }
        this.userDataReconcileTimer = new GhidraSwinglessTimer(300000, () -> {
            ProjectFileManager projectFileManager = this;
            synchronized (projectFileManager) {
                this.startReconcileUserDataFiles();
            }
        });
        this.userDataReconcileTimer.setRepeats(false);
        this.userDataReconcileTimer.start();
    }

    private void startReconcileUserDataFiles() {
        this.userDataReconcileThread = new Thread(() -> this.reconcileUserDataFiles());
        this.userDataReconcileThread.setPriority(1);
        this.userDataReconcileThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileUserDataFiles() {
        int count = 0;
        if (this.userFileSystem == null || !this.versionedFileSystem.isOnline()) {
            return;
        }
        try {
            for (String itemName : this.userFileSystem.getItemNames("/")) {
                if (!Thread.interrupted() && this.versionedFileSystem.isOnline()) {
                    String fileID;
                    if (!itemName.startsWith(USER_DATA_FILE_PREFIX) || this.fileIndex.getFileByID(fileID = itemName.substring(USER_DATA_FILE_PREFIX.length())) != null) continue;
                    LocalFileSystem localFileSystem = this.fileSystem;
                    synchronized (localFileSystem) {
                        LocalFolderItem item = this.userFileSystem.getItem("/", itemName);
                        if (item != null) {
                            ++count;
                            item.delete(-1, null);
                        }
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error while reconciling user data files", (Throwable)e);
        }
        if (count != 0) {
            Msg.info((Object)this, (Object)("Removed " + count + " user data files which were obsolete"));
        }
    }

    @Override
    public String makeValidName(String name) {
        int maxNameLength = this.getMaxNameLength();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < name.length() && buf.length() != maxNameLength; ++i) {
            char c = name.charAt(i);
            if (!LocalFileSystem.isValidNameCharacter((char)c)) continue;
            buf.append(c);
        }
        return buf.length() == 0 ? "unknown" : buf.toString();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public void close() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProjectFileManager projectFileManager = this;
        synchronized (projectFileManager) {
            if (this.userDataReconcileTimer != null) {
                this.userDataReconcileTimer.stop();
            }
            if (this.userDataReconcileThread != null) {
                this.userDataReconcileThread.interrupt();
            }
            this.projectDisposalMonitor.cancel();
            this.listenerList.clearAll();
        }
        projectFileManager = this.fileSystem;
        synchronized (projectFileManager) {
            this.rootFolderData.dispose();
            this.fileSystem.dispose();
            this.versionedFileSystem.dispose();
            this.versionedFileSystem.removeFileSystemListener((FileSystemListener)this.versionedFSListener);
            if (this.repository != null) {
                this.repository.disconnect();
                this.repository = null;
            }
        }
    }

    GhidraFolderData getRootFolderData() {
        return this.rootFolderData;
    }

    synchronized void setDomainObject(String pathname, DomainObjectAdapter doa) {
        if (this.openDomainObjects.containsKey(pathname)) {
            throw new RuntimeException("Attempted to re-open domain object: " + pathname);
        }
        DomainFile df = doa.getDomainFile();
        if (df instanceof GhidraFile) {
            this.openDomainObjects.remove(df.getPathname());
        }
        this.openDomainObjects.put(pathname, doa);
    }

    synchronized DomainObjectAdapter getOpenedDomainObject(String pathname) {
        return this.openDomainObjects.get(pathname);
    }

    synchronized boolean clearDomainObject(String pathname) {
        DomainObjectAdapter doa = this.openDomainObjects.get(pathname);
        if (doa != null) {
            this.openDomainObjects.remove(pathname);
            return true;
        }
        return false;
    }

    public void updateFileIndex(GhidraFileData fileData) {
        this.fileIndex.updateFileEntry(fileData);
    }

    public void removeFromIndex(String fileID) {
        this.fileIndex.removeFileEntry(fileID);
    }

    public TaskMonitor getProjectDisposalMonitor() {
        return this.projectDisposalMonitor;
    }

    class MyFileSystemListener
    implements FileSystemListener {
        MyFileSystemListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void folderCreated(String parentPath, String name) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    try {
                        folderData.folderChanged(name);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemCreated(String parentPath, String name) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    folderData.fileChanged(name);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void folderDeleted(String parentPath, String folderName) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    try {
                        folderData.folderChanged(folderName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void folderMoved(String parentPath, String folderName, String newParentPath) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    try {
                        folderData.folderChanged(folderName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(newParentPath, true)) != null) {
                    try {
                        folderData.folderChanged(folderName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void folderRenamed(String parentPath, String oldFolderName, String newFolderName) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    try {
                        folderData.folderChanged(oldFolderName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        folderData.folderChanged(newFolderName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        public void itemDeleted(String folderPath, String itemName) {
            GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(folderPath, true);
            if (folderData != null) {
                folderData.fileChanged(itemName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemRenamed(String folderPath, String oldItemName, String newItemName) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(folderPath, true);
                if (folderData != null) {
                    folderData.fileChanged(oldItemName);
                    folderData.fileChanged(newItemName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemMoved(String parentPath, String name, String newParentPath, String newName) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    folderData.fileChanged(name);
                }
                if ((folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(newParentPath, true)) != null) {
                    folderData.fileChanged(newName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemChanged(String parentPath, String itemName) {
            LocalFileSystem localFileSystem = ProjectFileManager.this.fileSystem;
            synchronized (localFileSystem) {
                GhidraFolderData folderData = ProjectFileManager.this.rootFolderData.getFolderPathData(parentPath, true);
                if (folderData != null) {
                    folderData.fileChanged(itemName);
                }
            }
        }

        public void syncronize() {
            if (SystemUtilities.isInHeadlessMode()) {
                this.doSynchronize();
                return;
            }
            try {
                FileSystemSynchronizer.setSynchronizing((boolean)true);
                TaskLauncher.launchModal((String)"Synchronizing Filesystem", this::doSynchronize);
            }
            finally {
                FileSystemSynchronizer.setSynchronizing((boolean)false);
            }
        }

        private void doSynchronize() {
            try {
                ProjectFileManager.this.rootFolderData.refresh(true, true, (TaskMonitor)ProjectFileManager.this.projectDisposalMonitor);
                ProjectFileManager.this.scheduleUserDataReconcilation();
            }
            catch (Exception e) {
                Msg.trace((Object)this, (Object)"Exception synchronizing filesystem", (Throwable)e);
            }
        }
    }
}

