/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class RetypeReturnAction
extends AbstractDecompilerAction {
    public RetypeReturnAction() {
        super("Retype Return");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeReturn"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Return"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        return tokenAtCursor.Parent() instanceof ClangReturnType;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        int resp;
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighFunction highFunction = context.getHighFunction();
        Function function = highFunction.getFunction();
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        ClangReturnType parent = (ClangReturnType)tokenAtCursor.Parent();
        DataType dataType = this.chooseDataType(tool, program, parent.getDataType());
        if (dataType == null) {
            return;
        }
        boolean commitRequired = RetypeReturnAction.checkFullCommit(null, highFunction);
        if (commitRequired && (resp = OptionDialog.showOptionDialog((Component)tool.getToolFrame(), (String)"Parameter Commit Required", (String)"Retyping the return value requires all other parameters to be committed!\nContinue with retype?", (String)"Continue")) != 1) {
            return;
        }
        boolean successfulMod = false;
        int transactionID = program.startTransaction("Retype return type");
        try {
            if (dataType.getDataTypeManager() != dataTypeManager) {
                dataType = dataTypeManager.resolve(dataType, null);
            }
            if (commitRequired) {
                try {
                    HighFunctionDBUtil.commitParamsToDatabase((HighFunction)highFunction, (boolean)true, (SourceType)SourceType.USER_DEFINED);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Unexpected exception", (Throwable)e);
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)((Object)this), null, (String)"Parameter Commit Failed", (Object)e.getMessage());
                }
            }
            function.setReturnType(dataType, SourceType.USER_DEFINED);
            successfulMod = true;
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type return type '" + this.getName() + "': " + e.getMessage()));
        }
        program.endTransaction(transactionID, successfulMod);
    }
}

