/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.HelpLocation;
import java.util.Set;

public class ForwardSliceToPCodeOpsAction
extends AbstractDecompilerAction {
    public ForwardSliceToPCodeOpsAction() {
        super("Highlight Forward Operator Slice");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionHighlight"));
        this.setPopupMenuData(new MenuData(new String[]{"Highlight", "Forward Operator Slice"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        return varnode != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        if (varnode != null) {
            PcodeOp op = tokenAtCursor.getPcodeOp();
            Set<PcodeOp> forwardSlice = DecompilerUtils.getForwardSliceToPCodeOps(varnode);
            if (op != null) {
                forwardSlice.add(op);
            }
            DecompilerPanel decompilerPanel = context.getDecompilerPanel();
            decompilerPanel.clearPrimaryHighlights();
            decompilerPanel.addPcodeOpHighlights(forwardSlice, decompilerPanel.getCurrentVariableHighlightColor());
        }
    }
}

