/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesService;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

public class FindReferencesToSymbolAction
extends AbstractDecompilerAction {
    private static final String MENU_ITEM_TEXT = "Find References to";
    public static final String NAME = "Find References to Symbol";

    public FindReferencesToSymbolAction() {
        super(NAME);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFindReferences"));
        this.setPopupMenuData(new MenuData(new String[]{"References", MENU_ITEM_TEXT}));
    }

    private void updateMenuName(Symbol symbol) {
        if (symbol == null) {
            return;
        }
        String symbolName = symbol.getName(false);
        String menuName = "Find References to " + symbolName;
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{"References", menuName});
        this.setPopupMenuData(data);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Symbol symbol = this.getSymbol(context);
        if (symbol == null) {
            return false;
        }
        this.updateMenuName(symbol);
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        LocationReferencesService service = (LocationReferencesService)context.getTool().getService(LocationReferencesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)("The " + LocationReferencesService.class.getSimpleName() + " is not installed.\nPlease add the plugin implementing this service."));
            return;
        }
        Symbol symbol = this.getSymbol(context);
        LabelFieldLocation location = new LabelFieldLocation(symbol);
        DecompilerProvider provider = context.getComponentProvider();
        service.showReferencesToLocation((ProgramLocation)location, (Navigatable)provider);
    }
}

