/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;

public class DataTypeDecompilerHover
extends AbstractConfigurableHover
implements DecompilerHoverService {
    private static final String NAME = "Data Type Display";
    private static final String DESCRIPTION = "Show data type contents when hovering over a type name.";
    private static final int PRIORITY = 20;

    protected DataTypeDecompilerHover(PluginTool tool) {
        super(tool, 20);
    }

    protected String getName() {
        return NAME;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected String getOptionsCategory() {
        return "Decompiler Popups";
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled) {
            return null;
        }
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
        DataType dt = this.getDataType(token);
        if (dt == null) {
            dt = this.getDataType(token.Parent());
        }
        if (dt != null) {
            String toolTipText = ToolTipUtils.getToolTipText((DataType)dt);
            return this.createTooltipComponent(toolTipText);
        }
        return null;
    }

    private DataType getDataType(ClangNode node) {
        HighVariable high;
        Varnode vn;
        if (node instanceof ClangVariableDecl) {
            return ((ClangVariableDecl)node).getDataType();
        }
        if (node instanceof ClangReturnType) {
            return ((ClangReturnType)node).getDataType();
        }
        if (node instanceof ClangTypeToken) {
            return ((ClangTypeToken)node).getDataType();
        }
        if (node instanceof ClangVariableToken && (vn = ((ClangVariableToken)node).getVarnode()) != null && (high = vn.getHigh()) != null) {
            return high.getDataType();
        }
        return null;
    }
}

