/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;

public class RemoveRowAction
extends DockingAction {
    private FieldHeaderLocation loc;
    private FieldHeader panel;

    public RemoveRowAction(String owner, FieldHeader panel) {
        super("Remove Row", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Remove Row"}, null, "field"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Remove Row"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof FieldHeaderLocation) {
            FieldFormatModel model;
            this.loc = (FieldHeaderLocation)contextObject;
            int row = this.loc.getRow();
            return row < (model = this.loc.getModel()).getNumRows() && model.getNumFactorys(row) == 0;
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        this.panel.setTabLock(true);
        this.loc.getModel().removeRow(this.loc.getRow());
        this.panel.getHeaderTab().update();
    }
}

