/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.XRefFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.XRefHeaderFieldLocation;
import java.math.BigInteger;
import java.util.List;

public class XRefHeaderFieldFactory
extends XRefFieldFactory {
    public static final String XREF_FIELD_NAME = "XRef Header";

    public XRefHeaderFieldFactory() {
        super(XREF_FIELD_NAME);
    }

    public XRefHeaderFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        super(XREF_FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.colorOptionName = "XRef Color";
        this.styleOptionName = "XRef Style";
        this.initDisplayOptions();
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        String headString = this.getXRefHeaderString(cu);
        if (headString == null || headString.length() == 0) {
            return null;
        }
        AttributedString as = new AttributedString(headString, this.color, this.getMetrics());
        TextFieldElement field = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)field, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        Address addr = cu.getMinAddress();
        return new XRefHeaderFieldLocation(cu.getProgram(), addr, cpath, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof XRefHeaderFieldLocation)) {
            return null;
        }
        XRefHeaderFieldLocation xRefLoc = (XRefHeaderFieldLocation)loc;
        if (xRefLoc.getRefAddress() != null) {
            return null;
        }
        if (!this.hasSamePath(bf, loc)) {
            return null;
        }
        return new FieldLocation(index, fieldNum, xRefLoc.getRow(), xRefLoc.getCharOffset());
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions options, ToolOptions fieldOptions) {
        return new XRefHeaderFieldFactory(formatModel, provider, (Options)options, fieldOptions);
    }

    private String getXRefHeaderString(CodeUnit cu) {
        if (cu == null) {
            return null;
        }
        Program prog = cu.getProgram();
        int xrefCount = prog.getReferenceManager().getReferenceCountTo(cu.getMinAddress());
        List<Reference> offcuts = XReferenceUtils.getOffcutXReferences(cu, this.maxXRefs);
        int offcutCount = offcuts.size();
        if (offcutCount > 0) {
            String modifier = "";
            if (offcutCount == this.maxXRefs) {
                modifier = "+";
            }
            return "XREF[" + xrefCount + "," + offcutCount + modifier + "]: ";
        }
        if (xrefCount > 0) {
            return "XREF[" + xrefCount + "]: ";
        }
        return null;
    }
}

