/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.EmptyProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.listing.Data;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.ResourceManager;

public class OpenCloseField
implements ListingField {
    private static final ImageIcon openImage = ResourceManager.loadImage((String)"images/small_minus.png");
    private static final ImageIcon closedImage = ResourceManager.loadImage((String)"images/small_plus.png");
    private FieldFactory factory;
    private int startX;
    private int startY;
    private int fieldWidth;
    private int heightAbove;
    private int heightBelow;
    private ProxyObj proxy;
    private boolean isOpen;
    private int indentLevel;
    private boolean isLast;
    private int toggleHandleSize;
    private int insetSpace = 1;

    public OpenCloseField(FieldFactory factory, ProxyObj proxy, int indentLevel, FontMetrics metrics, int x, int width, boolean isLast) {
        this.factory = factory;
        this.proxy = proxy;
        this.isOpen = proxy.getListingLayoutModel().isOpen((Data)proxy.getObject());
        this.fieldWidth = width;
        this.startX = x;
        this.indentLevel = indentLevel;
        this.isLast = isLast;
        this.heightAbove = metrics.getAscent();
        this.heightBelow = metrics.getLeading() + metrics.getDescent();
        this.toggleHandleSize = OpenCloseField.getOpenCloseHandleSize();
    }

    @Override
    public FieldFactory getFieldFactory() {
        return this.factory;
    }

    @Override
    public FieldFormatModel getFieldModel() {
        return this.factory.getFieldModel();
    }

    @Override
    public ProxyObj getProxy() {
        if (this.proxy == null) {
            return EmptyProxy.EMPTY_PROXY;
        }
        return this.proxy;
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.heightBelow;
    }

    public void setYPos(int yPos, int heightAbove, int heightBelow) {
        this.startY = yPos;
        this.heightAbove = heightAbove;
        this.heightBelow = heightBelow;
    }

    public int getWidth() {
        return (this.indentLevel + 1) * this.fieldWidth;
    }

    public int getPreferredWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.heightAbove + this.heightBelow;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        int toggleHandleStartY = -(this.heightAbove / 2 + this.toggleHandleSize / 2);
        int toggleHandleStartX = this.startX + this.indentLevel * this.fieldWidth + this.insetSpace;
        if (!context.isPrinting()) {
            if (this.isOpen) {
                g.drawImage(openImage.getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            } else {
                g.drawImage(closedImage.getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            }
        }
        g.setColor(Color.LIGHT_GRAY);
        int fieldTopY = -this.heightAbove;
        int fieldBottomY = this.heightBelow;
        int toggleHandleHalfLength = this.toggleHandleSize / 2;
        for (int i = 1; i < this.indentLevel; ++i) {
            int fieldOffset = i * this.fieldWidth;
            int previousButtonStartX = this.startX + fieldOffset + this.insetSpace;
            int midpointX = previousButtonStartX + toggleHandleHalfLength;
            g.drawLine(midpointX, fieldTopY, midpointX, fieldBottomY);
        }
        if (this.indentLevel > 0) {
            boolean lastAndClosed;
            int indentOffset = this.getWidth();
            int toggleHandleEndX = toggleHandleStartX + this.toggleHandleSize;
            int midpointY = toggleHandleStartY + this.toggleHandleSize / 2;
            int endX = this.startX + indentOffset;
            g.drawLine(toggleHandleEndX, midpointY, endX, midpointY);
            int midpointX = toggleHandleStartX + toggleHandleHalfLength;
            int endY = toggleHandleStartY - this.insetSpace;
            g.drawLine(midpointX, fieldTopY, midpointX, endY);
            boolean bl = lastAndClosed = this.isLast && !this.isOpen;
            if (!lastAndClosed) {
                int buttonBottomY = toggleHandleStartY + this.toggleHandleSize;
                g.drawLine(midpointX, buttonBottomY, midpointX, fieldBottomY);
            }
        }
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    private void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc != null) {
            g.setColor(cursorColor);
            Rectangle cursorBounds = this.getCursorBounds(cursorLoc.row(), cursorLoc.col());
            g.fillRect(cursorBounds.x, cursorBounds.y, cursorBounds.width, cursorBounds.height);
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.fieldWidth && y >= this.startY && y < this.startY + this.heightAbove + this.heightBelow;
    }

    public int getNumDataRows() {
        return 1;
    }

    public int getNumRows() {
        return 1;
    }

    public int getNumCols(int row) {
        return 0;
    }

    public int getX(int row, int col) {
        return this.startX;
    }

    public int getY(int row) {
        return this.startY;
    }

    public int getRow(int y) {
        return 0;
    }

    public int getCol(int row, int x) {
        return 0;
    }

    public boolean isValid(int row, int col) {
        return row == 0 && col == 0;
    }

    public Rectangle getCursorBounds(int row, int col) {
        if (!this.isValid(row, col)) {
            return null;
        }
        return new Rectangle(this.startX, -this.heightAbove, 2, this.heightAbove + this.heightBelow);
    }

    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < this.startY || topOfScreen > this.startY + this.heightAbove + this.heightBelow) {
            return max;
        }
        if (direction > 0) {
            return this.heightAbove + this.heightBelow - (topOfScreen - this.startY);
        }
        return this.startY - topOfScreen;
    }

    public boolean isPrimary() {
        return false;
    }

    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
        this.heightAbove = newHeightAbove;
        this.heightBelow = newHeightBelow;
    }

    public String getText() {
        return "";
    }

    public String getTextWithLineSeparators() {
        return "";
    }

    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new DefaultRowColLocation();
    }

    public int screenLocationToTextOffset(int row, int col) {
        return 0;
    }

    @Override
    public Object getClickedObject(FieldLocation fieldLocation) {
        return this;
    }

    public void toggleOpenCloseState() {
        this.proxy.getListingLayoutModel().toggleOpen((Data)this.proxy.getObject());
    }

    static int getOpenCloseHandleSize() {
        return openImage.getIconWidth();
    }
}

