/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DyldCacheUtils {
    public static final boolean isDyldCache(Program program) {
        if (program == null) {
            return false;
        }
        if (program.getMemory().getSize() < 16L) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (MemoryAccessException e) {
            return false;
        }
        return DyldCacheUtils.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(ByteProvider provider) {
        if (provider == null) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            bytes = provider.readBytes(0L, 16L);
        }
        catch (IOException e) {
            return false;
        }
        return DyldCacheUtils.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(String signature) {
        for (DyldArchitecture architecture : DyldArchitecture.ARCHITECTURES) {
            if (!architecture.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static class SplitDyldCache
    implements Closeable {
        List<ByteProvider> providers = new ArrayList<ByteProvider>();
        List<DyldCacheHeader> headers = new ArrayList<DyldCacheHeader>();

        public SplitDyldCache(ByteProvider baseProvider, boolean shouldProcessSymbols, boolean shouldCombineSplitFiles, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
            monitor.setMessage("Parsing " + baseProvider.getName() + " headers...");
            this.providers.add(baseProvider);
            DyldCacheHeader baseHeader = new DyldCacheHeader(new BinaryReader(baseProvider, true));
            baseHeader.parseFromFile(shouldProcessSymbols, log, monitor);
            this.headers.add(baseHeader);
            for (File splitFile : this.getSplitDyldCacheFiles(baseProvider, shouldCombineSplitFiles)) {
                monitor.setMessage("Parsing " + splitFile.getName() + " headers...");
                FileByteProvider provider = new FileByteProvider(splitFile, null, AccessMode.READ);
                if (!DyldCacheUtils.isDyldCache(provider)) continue;
                this.providers.add(provider);
                DyldCacheHeader splitHeader = new DyldCacheHeader(new BinaryReader(provider, true));
                splitHeader.parseFromFile(shouldProcessSymbols, log, monitor);
                this.headers.add(splitHeader);
                log.appendMsg("Including split DYLD: " + splitFile.getName());
            }
        }

        public ByteProvider getProvider(int i) {
            return this.providers.get(i);
        }

        public DyldCacheHeader getDyldCacheHeader(int i) {
            return this.headers.get(i);
        }

        public int size() {
            return this.providers.size();
        }

        @Override
        public void close() throws IOException {
            for (int i = 1; i < this.providers.size(); ++i) {
                this.providers.get(i).close();
            }
        }

        private List<File> getSplitDyldCacheFiles(ByteProvider baseProvider, boolean shouldCombineSplitFiles) {
            File file = baseProvider.getFile();
            if (file != null && shouldCombineSplitFiles) {
                String baseName = file.getName();
                File[] splitFiles = file.getParentFile().listFiles(f -> {
                    if (!f.getName().startsWith(baseName)) {
                        return false;
                    }
                    if (f.getName().equals(baseName)) {
                        return false;
                    }
                    return !f.getName().toLowerCase().endsWith(".map");
                });
                if (splitFiles != null) {
                    List<File> list = Arrays.asList(splitFiles);
                    Collections.sort(list);
                    return list;
                }
            }
            return Collections.emptyList();
        }
    }
}

