/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LibraryExportedSymbol;
import ghidra.app.util.opinion.LibraryLookupTable;
import ghidra.app.util.opinion.LibrarySymbolTable;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.app.util.opinion.PeLoader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public abstract class AbstractLibrarySupportLoader
extends AbstractProgramLoader {
    public static final String SYM_OPTION_NAME = "Create Export Symbol Files";
    public static final String LIB_OPTION_NAME = "Load External Libraries";
    static final boolean IS_CREATE_EXPORT_SYMBOL_FILES_DEFAULT = true;
    static final boolean IS_LOAD_LIBRARIES_DEFAULT = false;

    protected abstract void load(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4, TaskMonitor var5, MessageLog var6) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Program> loadProgram(ByteProvider provider, String programName, DomainFolder programFolder, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        HashSet<String> libraryNameSet = new HashSet<String>();
        HashSet<String> resolvedSet = new HashSet<String>();
        ArrayList<Program> programList = new ArrayList<Program>();
        boolean success = false;
        try {
            Program program = this.doLoad(provider, programName, programFolder, loadSpec, options, log, consumer, monitor, libraryNameSet);
            programList.add(program);
            monitor.checkCanceled();
            String parent = this.getProviderFilePath(provider);
            List<String> paths = LibrarySearchPathManager.getLibraryPathsList();
            if (parent != null) {
                paths.add(0, parent);
            }
            this.loadLibraries(programFolder, paths, loadSpec, options, log, consumer, libraryNameSet, resolvedSet, programList, monitor);
            this.apply(programList, options, log, monitor);
            success = true;
            ArrayList<Program> arrayList = programList;
            return arrayList;
        }
        finally {
            if (!success) {
                this.release(programList, consumer);
            }
        }
    }

    @Override
    protected boolean loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            log.appendMsg(provider.getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName());
            return false;
        }
        log.appendMsg("----- Loading " + provider.getAbsolutePath() + " -----");
        this.load(provider, loadSpec, options, program, monitor, log);
        return true;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        list.add(new Option(SYM_OPTION_NAME, true, Boolean.class, "-loader-createExportSymbolFiles"));
        list.add(new Option(LIB_OPTION_NAME, false, Boolean.class, "-loader-loadExternalLibs"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(SYM_OPTION_NAME) && !name.equals(LIB_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    protected void postLoadProgramFixups(List<Program> loadedPrograms, DomainFolder folder, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        this.resolveExternalLibs(loadedPrograms, folder, true, messageLog, monitor);
    }

    protected boolean isCaseInsensitiveLibraryFilenames() {
        return false;
    }

    private String getProviderFilePath(ByteProvider provider) {
        FSRL fsrl = provider.getFSRL();
        if (fsrl != null && !fsrl.getFS().hasContainer()) {
            return FilenameUtils.getFullPathNoEndSeparator((String)fsrl.getPath());
        }
        File f = provider.getFile();
        return f != null ? f.getParent() : null;
    }

    private void loadLibraries(DomainFolder programFolder, List<String> paths, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, Set<String> unprocessedLibs, Set<String> processedLibs, List<Program> programList, TaskMonitor monitor) throws CancelledException, IOException {
        if (loadSpec.getLoader() instanceof PeLoader ? !this.isCreateExportSymbolFiles(options) && !this.isLoadLibraries(options) : !this.isLoadLibraries(options)) {
            return;
        }
        for (String libName : new HashSet<String>(unprocessedLibs)) {
            monitor.checkCanceled();
            unprocessedLibs.remove(libName);
            if (processedLibs.contains(libName)) continue;
            boolean libImported = false;
            if (this.findAlreadyImportedLibrary(libName, programFolder) == null) {
                log.appendMsg("Searching for referenced library: " + libName + " ...");
                String simpleLibName = FilenameUtils.getName((String)libName);
                List<File> candidateLibFiles = this.findLibraryFileToImport(FilenameUtils.separatorsToUnix((String)libName), paths);
                for (File libFile : candidateLibFiles) {
                    monitor.checkCanceled();
                    if (!this.importLibrary(simpleLibName, programFolder, libFile, loadSpec, options, log, consumer, unprocessedLibs, programList, monitor)) continue;
                    libImported = true;
                    log.appendMsg("Found and imported external library: " + libFile);
                    break;
                }
                if (!libImported) {
                    log.appendMsg("Unable to find external library: " + libName);
                }
            }
            processedLibs.add(libName);
        }
        log.appendMsg("Finished importing referenced libraries for: " + programList.get(0).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(List<Program> programs, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)programs.size());
        for (int i = 0; i < programs.size() && this.isCreateExportSymbolFiles(options); ++i) {
            Program p = programs.get(i);
            monitor.checkCanceled();
            monitor.setProgress((long)i);
            int id = p.startTransaction("apply");
            boolean success = false;
            try {
                this.applyLibrarySymbols(p, log, monitor);
                this.applyImports(p, log, monitor);
                success = true;
                continue;
            }
            finally {
                p.endTransaction(id, success);
            }
        }
        LibraryLookupTable.cleanup();
    }

    private boolean isCreateExportSymbolFiles(List<Option> options) {
        boolean isCreateExportSymbolFiles = true;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(SYM_OPTION_NAME)) continue;
                isCreateExportSymbolFiles = (Boolean)option.getValue();
            }
        }
        return isCreateExportSymbolFiles;
    }

    private boolean isLoadLibraries(List<Option> options) {
        boolean isLoadLibraries = false;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(LIB_OPTION_NAME)) continue;
                isLoadLibraries = (Boolean)option.getValue();
            }
        }
        return isLoadLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doLoad(ByteProvider provider, String programName, DomainFolder programFolder, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor, Set<String> unprocessedLibraries) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language language = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec compilerSpec = language.getCompilerSpecByID(pair.compilerSpecID);
        monitor.setMessage(provider.getName());
        Address imageBaseAddr = language.getAddressFactory().getDefaultAddressSpace().getAddress(loadSpec.getDesiredImageBase());
        Program program = this.createProgram(provider, programName, imageBaseAddr, this.getName(), language, compilerSpec, consumer);
        int transactionID = program.startTransaction("importing");
        boolean success = false;
        try {
            log.appendMsg("----- Loading " + provider.getAbsolutePath() + " -----");
            this.load(provider, loadSpec, options, program, monitor, log);
            this.createDefaultMemoryBlocks(program, language, log);
            if (unprocessedLibraries != null) {
                ExternalManager extMgr = program.getExternalManager();
                Object[] externalNames = extMgr.getExternalLibraryNames();
                Arrays.sort(externalNames);
                for (Object name : externalNames) {
                    if (((String)name).equals(provider.getName()) || "<EXTERNAL>".equals(name)) continue;
                    unprocessedLibraries.add((String)name);
                }
            }
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            program.endTransaction(transactionID, success);
            if (!success) {
                program.release(consumer);
                program = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExternalLibs(List<Program> programs, DomainFolder domainFolder, boolean saveIfModified, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        Map<String, Program> progsByName = programs.stream().filter(Objects::nonNull).collect(Collectors.toMap(p -> p.getDomainFile().getName(), p -> p));
        monitor.initialize((long)progsByName.size());
        for (Program program : progsByName.values()) {
            monitor.incrementProgress(1L);
            if (monitor.isCancelled()) {
                return;
            }
            ExternalManager extManager = program.getExternalManager();
            String[] extLibNames = extManager.getExternalLibraryNames();
            if (extLibNames.length == 0 || extLibNames.length == 1 && "<EXTERNAL>".equals(extLibNames[0])) continue;
            monitor.setMessage("Resolving..." + program.getName());
            int id = program.startTransaction("resolving external references");
            try {
                this.resolveExternalLibs(program, progsByName, domainFolder, monitor, messageLog);
            }
            finally {
                program.endTransaction(id, true);
                if (!saveIfModified || !program.canSave() || !program.isChanged()) continue;
                program.save("Resolve external references", monitor);
            }
        }
    }

    private void resolveExternalLibs(Program program, Map<String, Program> progsByName, DomainFolder domainFolder, TaskMonitor monitor, MessageLog messageLog) throws CancelledException {
        String[] extLibNames;
        ExternalManager extManager = program.getExternalManager();
        for (String externalLibName : extLibNames = extManager.getExternalLibraryNames()) {
            if ("<EXTERNAL>".equals(externalLibName)) continue;
            monitor.checkCanceled();
            try {
                String externalFileName = FilenameUtils.getName((String)externalLibName);
                DomainObject matchingExtProgram = (DomainObject)progsByName.get(externalFileName);
                if (matchingExtProgram != null && matchingExtProgram.getDomainFile().exists()) {
                    extManager.setExternalPath(externalLibName, matchingExtProgram.getDomainFile().getPathname(), false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + matchingExtProgram.getDomainFile().getPathname() + "]");
                    continue;
                }
                DomainFile alreadyImportedLib = this.findAlreadyImportedLibrary(externalLibName, domainFolder);
                if (alreadyImportedLib != null) {
                    extManager.setExternalPath(externalLibName, alreadyImportedLib.getPathname(), false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + alreadyImportedLib.getPathname() + "] (previously imported)");
                    continue;
                }
                messageLog.appendMsg("  [" + externalLibName + "] -> not found");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Bad library name: " + externalLibName), (Throwable)e);
            }
        }
    }

    protected DomainFile findAlreadyImportedLibrary(String libPathFilename, DomainFolder domainFolder) {
        if (domainFolder == null) {
            return null;
        }
        String projectPath = AbstractLibrarySupportLoader.appendPath(domainFolder.getPathname(), libPathFilename);
        DomainFile alreadyImportedLibDF = domainFolder.getProjectData().getFile(FilenameUtils.separatorsToUnix((String)projectPath));
        if (alreadyImportedLibDF == null) {
            alreadyImportedLibDF = domainFolder.getFile(FilenameUtils.getName((String)libPathFilename));
        }
        if (alreadyImportedLibDF != null) {
            return alreadyImportedLibDF;
        }
        return null;
    }

    private static String appendPath(String ... pathStrs) {
        StringBuilder sb = new StringBuilder();
        for (String pathEle : pathStrs) {
            boolean eleStartsWithSlash;
            if (pathEle == null || pathEle.isEmpty()) continue;
            boolean sbEndsWithSlash = sb.length() > 0 && "/\\".indexOf(sb.charAt(sb.length() - 1)) != -1;
            boolean bl = eleStartsWithSlash = "/\\".indexOf(pathEle.charAt(0)) != -1;
            if (!sbEndsWithSlash && !eleStartsWithSlash && sb.length() > 0) {
                sb.append("/");
            } else if (eleStartsWithSlash && sbEndsWithSlash) {
                pathEle = pathEle.substring(1);
            }
            sb.append(pathEle);
        }
        return sb.toString();
    }

    private List<File> findLibraryFileToImport(String libPathFilename, List<String> importPaths) {
        File f;
        boolean libSpecifiesPath;
        String libName = FilenameUtils.getName((String)libPathFilename);
        ArrayList<File> results = new ArrayList<File>();
        for (String importPath : importPaths) {
            File importPathDir;
            if ((importPath = FilenameUtils.normalizeNoEndSeparator((String)importPath)) == null || importPath.isEmpty() || !(importPathDir = new File(importPath)).isAbsolute() || !importPathDir.isDirectory()) continue;
            String candidatePath = FilenameUtils.separatorsToSystem((String)AbstractLibrarySupportLoader.appendPath(importPath, libPathFilename));
            File f2 = this.resolveLibraryFile(new File(candidatePath));
            if (f2 == null || !f2.isFile()) {
                f2 = this.resolveLibraryFile(new File(importPathDir, libName));
            }
            if (f2 == null || !f2.isFile() || results.contains(f2)) continue;
            results.add(f2);
        }
        boolean searchLocalFileSystemAlso = true;
        boolean bl = libSpecifiesPath = FilenameUtils.getPrefixLength((String)libPathFilename) > 0;
        if (searchLocalFileSystemAlso && libSpecifiesPath && (f = this.resolveLibraryFile(new File(libPathFilename))) != null && f.isAbsolute() && f.isFile() && !results.contains(f)) {
            results.add(f);
        }
        return results;
    }

    protected boolean importLibrary(String libName, DomainFolder libFolder, File libFile, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, Set<String> unprocessedLibs, List<Program> programList, TaskMonitor monitor) throws CancelledException, IOException {
        if (!libFile.isFile()) {
            return false;
        }
        try (RandomAccessByteProvider provider = new RandomAccessByteProvider(libFile);){
            boolean bl = this.importLibrary(libName, libFolder, libFile, provider, loadSpec, options, log, consumer, unprocessedLibs, programList, monitor);
            return bl;
        }
    }

    protected boolean importLibrary(String libName, DomainFolder libFolder, File libFile, ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, Set<String> unprocessedLibs, List<Program> programList, TaskMonitor monitor) throws CancelledException, IOException {
        Program lib = null;
        int size = loadSpec.getLanguageCompilerSpec().getLanguageDescription().getSize();
        LoadSpec libLoadSpec = this.getLoadSpec(loadSpec, provider);
        if (libLoadSpec == null) {
            log.appendMsg("Skipping library which is the wrong architecture: " + libFile);
            return false;
        }
        if (!this.isLoadLibraries(options)) {
            if (LibraryLookupTable.hasFileAndPathAndTimeStampMatch(libFile, size)) {
                return true;
            }
            if (LibraryLookupTable.libraryLookupTableFileExists(libName, size)) {
                log.appendMsg("WARNING! Using existing exports file for " + libName + " which may not be an exact match");
                return true;
            }
        }
        if ((lib = this.doLoad(provider, libName, libFolder, libLoadSpec, options, log, consumer, monitor, unprocessedLibs)) == null) {
            log.appendMsg("Library " + libFile + " failed to load for some reason");
            return false;
        }
        this.createExportsFile(libName, libFile, log, monitor, size, lib);
        if (this.isLoadLibraries(options)) {
            programList.add(lib);
        } else {
            lib.release(consumer);
        }
        return true;
    }

    protected void createExportsFile(String libName, File libFile, MessageLog log, TaskMonitor monitor, int size, Program program) throws CancelledException {
        if (!LibraryLookupTable.libraryLookupTableFileExists(libName, size) || !LibraryLookupTable.hasFileAndPathAndTimeStampMatch(libFile, size)) {
            try {
                LibraryLookupTable.createFile(program, true, monitor);
            }
            catch (IOException e) {
                log.appendMsg("Unable to create exports file for " + libFile);
                Msg.error((Object)this, (Object)("Unable to create exports file for " + libFile), (Throwable)e);
            }
        }
    }

    protected LoadSpec getLoadSpec(LoadSpec loadSpec, ByteProvider provider) throws IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Collection<LoadSpec> loadSpecs = this.findSupportedLoadSpecs(provider);
        if (loadSpecs != null) {
            for (LoadSpec ls : loadSpecs) {
                if (!pair.equals((Object)ls.getLanguageCompilerSpec())) continue;
                return ls;
            }
        }
        return null;
    }

    private void applyLibrarySymbols(Program program, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Applying information..." + program.getName());
        int size = program.getLanguage().getLanguageDescription().getSize();
        LibrarySymbolTable symtab = LibraryLookupTable.getSymbolTable(new File(program.getExecutablePath()).getName(), size);
        if (symtab == null && (symtab = LibraryLookupTable.getSymbolTable(program.getName(), size)) == null) {
            return;
        }
        if (!this.isVersionMatch((DomainObject)program, symtab, log)) {
            return;
        }
        SymbolIterator iter = program.getSymbolTable().getSymbolIterator("Ordinal_*", true);
        while (iter.hasNext()) {
            int ordinal;
            LibraryExportedSymbol les;
            monitor.checkCanceled();
            Symbol ordSym = iter.next();
            if (!ordSym.getAddress().isMemoryAddress() || !ordSym.getParentNamespace().equals(program.getGlobalNamespace()) || (les = symtab.getSymbol(ordinal = SymbolUtilities.getOrdinalValue((String)ordSym.getName()))) == null || les.getName() == null) continue;
            try {
                Symbol nameSym = program.getSymbolTable().getGlobalSymbol(les.getName(), ordSym.getAddress());
                if (nameSym != null) continue;
                String name = les.getName();
                Symbol s = program.getSymbolTable().createLabel(ordSym.getAddress(), name, program.getGlobalNamespace(), SourceType.IMPORTED);
                s.setPrimary();
            }
            catch (InvalidInputException e) {
                log.appendMsg("Error creating label named " + les.getName() + " at address " + ordSym.getAddress() + ": " + e.getMessage());
            }
        }
    }

    private void applyImports(Program program, MessageLog log, TaskMonitor monitor) {
        String[] libs;
        monitor.setMessage("Applying imports..." + program.getName());
        ReferenceManager rm = program.getReferenceManager();
        ExternalManager em = program.getExternalManager();
        for (String lib : libs = em.getExternalLibraryNames()) {
            ExternalReference[] erArray;
            if (monitor.isCancelled()) {
                return;
            }
            int size = program.getLanguage().getLanguageDescription().getSize();
            LibrarySymbolTable symtab = LibraryLookupTable.getSymbolTable(lib, size);
            for (ExternalReference element : erArray = this.getExternalReferences(rm, lib)) {
                boolean isNot32Bit;
                if (monitor.isCancelled()) {
                    return;
                }
                String symName = element.getLabel();
                if (symtab == null) continue;
                ExternalLocation extLoc = element.getExternalLocation();
                LibraryExportedSymbol expSym = symtab.getSymbol(symName);
                if (expSym == null) {
                    try {
                        int ord = SymbolUtilities.getOrdinalValue((String)symName);
                        if (ord == -1) continue;
                        expSym = symtab.getSymbol(ord);
                        if (expSym == null) {
                            log.appendMsg("Unable to locate symbol [" + symName + "] in [" + LibraryLookupTable.getExistingExportsFile(lib, size) + "]. Please verify the version is correct.");
                            continue;
                        }
                        extLoc.setLocation(expSym.getName(), extLoc.getAddress(), SourceType.IMPORTED);
                    }
                    catch (DuplicateNameException | InvalidInputException e) {
                        log.appendMsg("Error creating label: ", e.getMessage());
                    }
                }
                Listing listing = program.getListing();
                Data data = listing.getDataAt(element.getFromAddress());
                int purgeSize = expSym.getPurge();
                boolean bl = isNot32Bit = data.getMinAddress().getAddressSpace().getSize() > 32;
                if (purgeSize == -1 || purgeSize < -1024 || purgeSize > 1024 || isNot32Bit) continue;
                Function extFunc = extLoc.createFunction();
                extFunc.setStackPurgeSize(purgeSize);
                if (!expSym.hasNoReturn()) continue;
                extFunc.setNoReturn(true);
            }
        }
    }

    private static String getRidOfVersionAlias(String version) {
        if (version == null) {
            return null;
        }
        int aliasOpenParenPosition = version.indexOf(40);
        if (aliasOpenParenPosition == -1) {
            return version.trim();
        }
        return version.substring(0, aliasOpenParenPosition).trim();
    }

    private boolean isVersionMatch(DomainObject p, LibrarySymbolTable symtab, MessageLog log) {
        String version = AbstractLibrarySupportLoader.getRidOfVersionAlias(symtab.getVersion());
        Options options = p.getOptions("Program Information");
        String programVersion = AbstractLibrarySupportLoader.getRidOfVersionAlias(options.getString("ProductVersion", (String)null));
        if (programVersion == null) {
            return false;
        }
        boolean match = programVersion.equalsIgnoreCase(version);
        if (!match) {
            log.appendMsg("Library version mismatch in .exports file for " + p.getName());
            log.appendMsg("   expected " + programVersion + " but was " + version);
        }
        return match;
    }

    private ExternalReference[] getExternalReferences(ReferenceManager rm, String externalName) {
        ArrayList<ExternalReference> list = new ArrayList<ExternalReference>();
        ReferenceIterator iter = rm.getExternalReferences();
        while (iter.hasNext()) {
            ExternalReference ref = (ExternalReference)iter.next();
            if (!ref.getLibraryName().equals(externalName)) continue;
            list.add(ref);
        }
        ExternalReference[] arr = new ExternalReference[list.size()];
        list.toArray(arr);
        return arr;
    }

    private File resolveLibraryFile(File libFile) {
        if (this.isCaseInsensitiveLibraryFilenames()) {
            return FileUtilities.resolveFileCaseInsensitive((File)libFile);
        }
        return libFile;
    }
}

