/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BoundImportForwarderRef
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_BOUND_FORWARDER_REF";
    public static final int IMAGE_SIZEOF_BOUND_IMPORT_FORWARDER_REF = 8;
    private int timeDateStamp;
    private short offsetModuleName;
    private short reserved;
    private String moduleName;

    static BoundImportForwarderRef createBoundImportForwarderRef(FactoryBundledWithBinaryReader reader, int readerIndex, int biddIndex) throws IOException {
        BoundImportForwarderRef boundImportForwarderRef = (BoundImportForwarderRef)reader.getFactory().create(BoundImportForwarderRef.class, new Object[0]);
        boundImportForwarderRef.initBoundImportForwarderRef(reader, readerIndex, biddIndex);
        return boundImportForwarderRef;
    }

    private void initBoundImportForwarderRef(FactoryBundledWithBinaryReader reader, int readerIndex, int biddIndex) throws IOException {
        this.timeDateStamp = reader.readInt(readerIndex);
        this.offsetModuleName = reader.readShort(readerIndex += 4);
        this.reserved = reader.readShort(readerIndex += 2);
        readerIndex += 2;
        if (this.offsetModuleName < 0) {
            Msg.error((Object)this, (Object)("Invalid offsetModuleName " + Integer.toHexString(this.offsetModuleName)));
            return;
        }
        this.moduleName = reader.readAsciiString(biddIndex + this.offsetModuleName);
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[8];
        int pos = 0;
        dc.getBytes(this.timeDateStamp, bytes, pos);
        dc.getBytes(this.offsetModuleName, bytes, pos += 4);
        dc.getBytes(this.reserved, bytes, pos += 2);
        pos += 2;
        return bytes;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public short getOffsetModuleName() {
        return this.offsetModuleName;
    }

    void setOffsetModuleName(short offset) {
        this.offsetModuleName = offset;
    }

    public short getReserved() {
        return this.reserved;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(WORD, "OffsetModuleName", null);
        struct.add(WORD, "Reserved", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

