/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Method;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_MethodList
extends ObjectiveC_MethodList {
    public static final String NAME = "method_list_t";
    private int entsizeAndFlags;
    private int count;

    public ObjectiveC2_MethodList(ObjectiveC2_State state, BinaryReader reader, ObjectiveC_MethodType methodType) throws IOException {
        super(state, reader, NAME);
        if (this._index == 0L) {
            return;
        }
        this.entsizeAndFlags = reader.readNextInt();
        this.count = reader.readNextInt();
        boolean isSmallList = (this.entsizeAndFlags & Integer.MIN_VALUE) != 0;
        for (int i = 0; i < this.count; ++i) {
            this.methods.add(new ObjectiveC2_Method(state, reader, methodType, isSmallList));
        }
    }

    public long getEntsizeAndFlags() {
        return this.entsizeAndFlags;
    }

    public long getCount() {
        return this.count;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "entsizeAndFlags", null);
        struct.add(DWORD, "count", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("method_list_t_" + this.count + "_", 0);
        struct.add(DWORD, "entsizeAndFlags", null);
        struct.add(DWORD, "count", null);
        for (int i = 0; i < this.methods.size(); ++i) {
            struct.add(((ObjectiveC_Method)this.methods.get(i)).toDataType(), "method" + i, null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }
}

