/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class FileSetEntryCommand
extends LoadCommand {
    private long vmaddr;
    private long fileoff;
    private String entryName;
    private long unknown;
    boolean is32bit;

    public static FileSetEntryCommand createFileSetEntryCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        FileSetEntryCommand filesetEntryCommand = (FileSetEntryCommand)reader.getFactory().create(FileSetEntryCommand.class, new Object[0]);
        filesetEntryCommand.initFileSetEntryCommand(reader, is32bit);
        return filesetEntryCommand;
    }

    private void initFileSetEntryCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        this.initLoadCommand(reader);
        this.is32bit = is32bit;
        if (is32bit) {
            this.vmaddr = reader.readNextUnsignedInt();
            this.fileoff = reader.readNextUnsignedInt();
            this.unknown = reader.readNextUnsignedInt();
        } else {
            this.vmaddr = reader.readNextLong();
            this.fileoff = reader.readNextLong();
            this.unknown = reader.readNextLong();
        }
        int stringSize = this.getCommandSize() - (8 + 3 * (is32bit ? 4 : 8));
        this.entryName = reader.readNextAsciiString(stringSize);
    }

    public String getFileSetEntryName() {
        return this.entryName;
    }

    public long getVMaddress() {
        return this.vmaddr;
    }

    public long getFileOffset() {
        return this.fileoff;
    }

    public long getUnknown() {
        return this.unknown;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        if (this.is32bit) {
            struct.add(DWORD, "vmaddr", null);
            struct.add(DWORD, "fileoff", null);
            struct.add(DWORD, "unknown", null);
        } else {
            struct.add(QWORD, "vmaddr", null);
            struct.add(QWORD, "fileoff", null);
            struct.add(QWORD, "unknown", null);
        }
        int stringSize = this.getCommandSize() - (8 + 3 * (this.is32bit ? 4 : 8));
        struct.add((DataType)new StringDataType(), stringSize, "fileSetEntryname", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "fileset_entry_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                DataType fileSetEntryDT = this.toDataType();
                api.createData(addr, fileSetEntryDT);
                api.setPlateComment(addr, this.getFileSetEntryName());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }

    public String toString() {
        return this.getFileSetEntryName();
    }
}

