/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldChainedStartsInSegment
implements StructConverter {
    private int size;
    private short page_size;
    private short pointer_format;
    private long segment_offset;
    private int max_valid_pointer;
    private short page_count;
    private short[] page_starts;
    private short[] chain_starts;

    static DyldChainedStartsInSegment createDyldChainedFixupHeader(FactoryBundledWithBinaryReader reader) throws IOException {
        DyldChainedStartsInSegment dyldChainedFixupHeader = (DyldChainedStartsInSegment)reader.getFactory().create(DyldChainedStartsInSegment.class, new Object[0]);
        dyldChainedFixupHeader.initDyldChainedStartsInSegment(reader);
        return dyldChainedFixupHeader;
    }

    private void initDyldChainedStartsInSegment(FactoryBundledWithBinaryReader reader) throws IOException {
        this.size = reader.readNextInt();
        this.page_size = reader.readNextShort();
        this.pointer_format = reader.readNextShort();
        this.segment_offset = reader.readNextLong();
        this.max_valid_pointer = reader.readNextInt();
        this.page_count = reader.readNextShort();
        this.page_starts = reader.readNextShortArray(this.page_count);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_starts_in_segment", 0);
        struct.add(DWORD, "size", null);
        struct.add(WORD, "page_size", null);
        struct.add(WORD, "pointer_format", null);
        struct.add(QWORD, "segment_offset", null);
        struct.add(DWORD, "max_valid_pointer", null);
        struct.add(WORD, "page_count", null);
        struct.add((DataType)new ArrayDataType(WORD, (int)this.page_count, 1), "page_starts", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getSize() {
        return this.size;
    }

    public short getPageSize() {
        return this.page_size;
    }

    public short getPointerFormat() {
        return this.pointer_format;
    }

    public long getSegmentOffset() {
        return this.segment_offset;
    }

    public int getMaxValidPointer() {
        return this.max_valid_pointer;
    }

    public short getPageCount() {
        return this.page_count;
    }

    public short[] getPage_starts() {
        return this.page_starts;
    }

    public short[] getChain_starts() {
        return this.chain_starts;
    }
}

