/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.util.DataConverter;
import ghidra.util.StringUtilities;
import java.io.IOException;

public class ElfDynamic
implements ByteArrayConverter {
    private ElfHeader elf;
    private int d_tag;
    private long d_val;

    public static ElfDynamic createElfDynamic(FactoryBundledWithBinaryReader reader, ElfHeader elf) throws IOException {
        ElfDynamic elfDynamic = (ElfDynamic)reader.getFactory().create(ElfDynamic.class, new Object[0]);
        elfDynamic.initElfDynamic(reader, elf);
        return elfDynamic;
    }

    public ElfDynamic() {
    }

    private void initElfDynamic(FactoryBundledWithBinaryReader reader, ElfHeader elf) throws IOException {
        this.elf = elf;
        if (elf.is32Bit()) {
            this.d_tag = reader.readNextInt();
            this.d_val = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else {
            this.d_tag = (int)reader.readNextLong();
            this.d_val = reader.readNextLong();
        }
    }

    public ElfDynamic(int tag, long value, ElfHeader elf) {
        this.d_tag = tag;
        this.d_val = value;
        this.elf = elf;
    }

    public ElfDynamic(ElfDynamicType tag, long value, ElfHeader elf) {
        this(tag.value, value, elf);
    }

    public int getTag() {
        return this.d_tag;
    }

    public ElfDynamicType getTagType() {
        return this.elf.getDynamicType(this.d_tag);
    }

    public long getValue() {
        return this.d_val;
    }

    public void setValue(long value) {
        this.d_val = value;
    }

    public void setValue(int value) {
        this.d_val = (long)value & 0xFFFFFFFFL;
    }

    public String getTagAsString() {
        ElfDynamicType tagType = this.getTagType();
        if (tagType != null) {
            return tagType.name;
        }
        return "DT_0x" + StringUtilities.pad((String)Integer.toHexString(this.d_tag), (char)'0', (int)8);
    }

    public String toString() {
        return this.getTagAsString();
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.sizeof()];
        this.write(bytes, 0, dc);
        return bytes;
    }

    public void write(byte[] data, int offset, DataConverter dc) throws ArrayIndexOutOfBoundsException {
        if (this.elf.is32Bit()) {
            dc.putInt(data, offset, this.d_tag);
            dc.putInt(data, offset + 4, (int)this.d_val);
        } else {
            dc.putLong(data, offset, (long)this.d_tag);
            dc.putLong(data, offset + 8, this.d_val);
        }
    }

    public int sizeof() {
        return this.elf.is32Bit() ? 8 : 16;
    }
}

