/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.util.bean.SelectLanguagePanel;
import ghidra.framework.Application;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.ExternalLanguageCompilerSpecQuery;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.VersionedLanguageService;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.LanguageTranslatorAdapter;
import ghidra.program.util.OldLanguageFactory;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.xml.GenericXMLOutputter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.STABLE, packageName="Developer", category="Miscellaneous", shortDescription="Generate Old Language File", description="This plugin allows the user to generate an old-language XML file from the current version of a loaded language.  This should be done prior to making any changes to a language which will modify its address spaces or register definitions.")
public class GenerateOldLanguagePlugin
extends Plugin
implements FrontEndable {
    private static final ExtensionFileFilter OLD_LANG_FILTER = new ExtensionFileFilter("lang", "Old Language File");
    private static final ExtensionFileFilter TRANSLATOR_FILTER = new ExtensionFileFilter("trans", "Simple Translator File");
    private DockingAction generateOldLanguageAction;
    private DockingAction generateTranslatorAction;

    public GenerateOldLanguagePlugin(PluginTool plugintool) {
        super(plugintool);
    }

    protected void init() {
        this.generateOldLanguageAction = new DockingAction("Generate Old Language File", this.getName()){

            public void actionPerformed(ActionContext context) {
                GenerateOldLanguageDialog dialogProvider = new GenerateOldLanguageDialog(false);
                GenerateOldLanguagePlugin.this.tool.showDialog((DialogComponentProvider)dialogProvider);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        this.generateOldLanguageAction.setMenuBarData(new MenuData(new String[]{"File", "Generate Old Language File..."}, null, "Language"));
        this.generateOldLanguageAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.generateOldLanguageAction);
        this.generateTranslatorAction = new DockingAction("Generate Simple Language Translator", this.getName()){

            public void actionPerformed(ActionContext context) {
                GenerateOldLanguageDialog dialogProvider = new GenerateOldLanguageDialog(true);
                GenerateOldLanguagePlugin.this.tool.showDialog((DialogComponentProvider)dialogProvider);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        this.generateTranslatorAction.setMenuBarData(new MenuData(new String[]{"File", "Generate Simple Language Translator..."}, null, "Language"));
        this.generateTranslatorAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.generateTranslatorAction);
    }

    protected void dispose() {
        this.tool.removeAction((DockingActionIf)this.generateOldLanguageAction);
        this.tool.removeAction((DockingActionIf)this.generateTranslatorAction);
        super.dispose();
    }

    private static class DeprecatedLanguageService
    implements VersionedLanguageService {
        LanguageService langService = DefaultLanguageService.getLanguageService();
        OldLanguageFactory oldLangFactory = OldLanguageFactory.getOldLanguageFactory();
        private final boolean includeOldLanguages;

        DeprecatedLanguageService(boolean includeOldLanguages) {
            this.includeOldLanguages = includeOldLanguages;
        }

        public Language getDefaultLanguage(Processor processor) {
            throw new UnsupportedOperationException();
        }

        public Language getLanguage(LanguageID languageID) throws LanguageNotFoundException {
            try {
                return this.langService.getLanguage(languageID);
            }
            catch (LanguageNotFoundException e) {
                LanguageDescription langDescr = this.oldLangFactory.getLatestOldLanguage(languageID);
                if (langDescr != null) {
                    return this.oldLangFactory.getOldLanguage(languageID, langDescr.getVersion());
                }
                throw e;
            }
        }

        public Language getLanguage(LanguageID languageID, int version) throws LanguageNotFoundException {
            Language language = this.oldLangFactory.getOldLanguage(languageID, version);
            if (language == null && (language = this.langService.getLanguage(languageID)) != null && language.getLanguageDescription().getVersion() != version) {
                throw new LanguageNotFoundException(languageID, "version: " + version);
            }
            return language;
        }

        public LanguageDescription getLanguageDescription(LanguageID languageID) throws LanguageNotFoundException {
            try {
                return this.langService.getLanguageDescription(languageID);
            }
            catch (LanguageNotFoundException e) {
                LanguageDescription langDescr = this.oldLangFactory.getLatestOldLanguage(languageID);
                if (langDescr != null) {
                    return langDescr;
                }
                throw e;
            }
        }

        public LanguageDescription getLanguageDescription(LanguageID languageID, int version) throws LanguageNotFoundException {
            Language language = this.oldLangFactory.getOldLanguage(languageID, version);
            if (language != null) {
                return language.getLanguageDescription();
            }
            LanguageDescription languageDescription = this.langService.getLanguageDescription(languageID);
            if (languageDescription.getVersion() != version) {
                throw new LanguageNotFoundException(languageID, "version: " + version);
            }
            return languageDescription;
        }

        public List<LanguageDescription> getLanguageDescriptions(boolean includeDeprecatedLanguages) {
            ArrayList<LanguageDescription> list = new ArrayList<LanguageDescription>();
            list.addAll(this.langService.getLanguageDescriptions(true));
            if (this.includeOldLanguages) {
                list.addAll(Arrays.asList(this.oldLangFactory.getLatestOldLanaguageDescriptions()));
            }
            return list;
        }

        public List<LanguageDescription> getLanguageDescriptions(Processor processor, Endian endianess, Integer size, String variant) {
            throw new UnsupportedOperationException();
        }

        public List<LanguageDescription> getLanguageDescriptions(Processor processorName) {
            throw new UnsupportedOperationException();
        }

        public List<LanguageCompilerSpecPair> getLanguageCompilerSpecPairs(LanguageCompilerSpecQuery query) {
            throw new UnsupportedOperationException();
        }

        public List<LanguageCompilerSpecPair> getLanguageCompilerSpecPairs(ExternalLanguageCompilerSpecQuery query) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DummyLanguageTranslator
    extends LanguageTranslatorAdapter {
        private boolean canMapSpaces;
        private boolean canMapContext;

        DummyLanguageTranslator(Language oldLanguage, Language newLanguage) {
            super(oldLanguage.getLanguageID(), oldLanguage.getVersion(), newLanguage.getLanguageID(), newLanguage.getVersion());
        }

        public boolean isValid() {
            if (super.isValid()) {
                try {
                    this.validateDefaultSpaceMap();
                    this.canMapSpaces = true;
                }
                catch (IncompatibleLanguageException e) {
                    this.canMapSpaces = false;
                    Msg.error((Object)((Object)this), (Object)e.getMessage());
                }
                return true;
            }
            return false;
        }

        boolean canMapSpaces() {
            return this.canMapSpaces;
        }

        boolean canMapContext() {
            return this.canMapContext;
        }
    }

    private class GenerateTranslatorDialog
    extends DialogComponentProvider {
        private JPanel panel;
        private SelectLanguagePanel selectLangPanel;
        private GhidraFileChooser chooser;
        private Language oldLang;
        private File oldLangFile;

        GenerateTranslatorDialog(Language oldLang, File oldLangFile) {
            super("Select New Language", true, true, true, false);
            this.oldLang = oldLang;
            this.oldLangFile = oldLangFile;
            this.selectLangPanel = new SelectLanguagePanel(DefaultLanguageService.getLanguageService());
            this.selectLangPanel.setPreferredSize(new Dimension(450, 150));
            this.selectLangPanel.setShowVersion(true);
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.panel.add((Component)this.selectLangPanel, "Center");
            this.addWorkPanel(this.panel);
            this.setStatusText("Please select target language");
            JButton genButton = new JButton("Generate...");
            genButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    File transFile;
                    Language lang = GenerateTranslatorDialog.this.selectLangPanel.getSelectedLanguage();
                    if (lang == null) {
                        GenerateTranslatorDialog.this.setStatusText("Please select target language");
                        return;
                    }
                    if (GenerateTranslatorDialog.this.oldLangFile == null) {
                        if (GenerateTranslatorDialog.this.chooser == null) {
                            GenerateTranslatorDialog.this.chooser = new GhidraFileChooser((Component)GenerateTranslatorDialog.this.panel);
                            GenerateTranslatorDialog.this.chooser.setTitle("Specify Old Language Output File");
                            GenerateTranslatorDialog.this.chooser.setFileFilter((GhidraFileFilter)TRANSLATOR_FILTER);
                            GenerateTranslatorDialog.this.chooser.setApproveButtonText("Create");
                            GenerateTranslatorDialog.this.chooser.setCurrentDirectory(Application.getApplicationRootDirectory().getFile(false));
                        }
                        if ((transFile = GenerateTranslatorDialog.this.chooser.getSelectedFile(true)) == null) {
                            return;
                        }
                        if (!transFile.getName().endsWith(".trans")) {
                            transFile = new File(transFile.getParent(), transFile.getName() + ".trans");
                        }
                    } else {
                        Object filename = GenerateTranslatorDialog.this.oldLangFile.getName();
                        int index = ((String)filename).indexOf(".lang");
                        if (index > 0) {
                            filename = ((String)filename).substring(0, index) + ".trans";
                        }
                        transFile = new File(GenerateTranslatorDialog.this.oldLangFile.getParentFile(), (String)filename);
                    }
                    if (transFile.exists() && OptionDialog.showYesNoDialog((Component)GenerateTranslatorDialog.this.panel, (String)"Confirm Overwrite", (String)("Overwrite file " + transFile.getName() + "?")) != 1) {
                        return;
                    }
                    try {
                        GenerateTranslatorDialog.this.buildDefaultTranslator(lang, transFile);
                    }
                    catch (IOException e) {
                        Msg.showError((Object)this, (Component)GenerateTranslatorDialog.this.panel, (String)"IO Error", (Object)("Error occurred while generating translator file:\n" + transFile), (Throwable)e);
                    }
                    GenerateTranslatorDialog.this.close();
                }
            });
            this.addButton(genButton);
            this.addCancelButton();
        }

        public void close() {
            super.close();
            this.selectLangPanel.dispose();
        }

        private void buildDefaultTranslator(Language newLang, File transFile) throws IOException {
            DummyLanguageTranslator defaultTrans = new DummyLanguageTranslator(this.oldLang, newLang);
            if (!defaultTrans.isValid()) {
                throw new AssertException();
            }
            Element root = new Element("language_translation");
            Element fromLang = new Element("from_language");
            fromLang.setAttribute("version", Integer.toString(this.oldLang.getVersion()));
            fromLang.setText(this.oldLang.getLanguageID().getIdAsString());
            root.addContent((Content)fromLang);
            Element toLang = new Element("to_language");
            toLang.setAttribute("version", Integer.toString(newLang.getVersion()));
            toLang.setText(newLang.getLanguageID().getIdAsString());
            root.addContent((Content)toLang);
            for (CompilerSpecDescription oldCompilerSpecDescription : this.oldLang.getCompatibleCompilerSpecDescriptions()) {
                String newId;
                CompilerSpecID oldCompilerSpecID = oldCompilerSpecDescription.getCompilerSpecID();
                try {
                    newId = newLang.getCompilerSpecByID(oldCompilerSpecID).getCompilerSpecID().getIdAsString();
                }
                catch (CompilerSpecNotFoundException e) {
                    newId = newLang.getDefaultCompilerSpec().getCompilerSpecID().getIdAsString();
                }
                Element compilerSpecMapElement = new Element("map_compiler_spec");
                compilerSpecMapElement.setAttribute("from", oldCompilerSpecID.getIdAsString());
                compilerSpecMapElement.setAttribute("to", newId);
                root.addContent((Content)compilerSpecMapElement);
            }
            if (!defaultTrans.canMapSpaces) {
                for (AddressSpace space : this.oldLang.getAddressFactory().getPhysicalSpaces()) {
                    Element mapSpaceElement = new Element("map_space");
                    mapSpaceElement.setAttribute("from", space.getName());
                    mapSpaceElement.setAttribute("to", "?" + space.getSize());
                    root.addContent((Content)mapSpaceElement);
                }
            }
            for (Register reg : this.oldLang.getRegisters()) {
                Register newReg = defaultTrans.getNewRegister(reg);
                if (newReg != null) continue;
                Element mapRegElement = new Element("map_register");
                mapRegElement.setAttribute("from", reg.getName());
                mapRegElement.setAttribute("to", "?" + reg.getMinimumByteSize());
                mapRegElement.setAttribute("size", Integer.toString(reg.getMinimumByteSize()));
                root.addContent((Content)mapRegElement);
            }
            Document doc = new Document(root);
            FileOutputStream out = new FileOutputStream(transFile);
            GenericXMLOutputter xml = new GenericXMLOutputter();
            xml.output(doc, (OutputStream)out);
            out.close();
            Register oldCtx = this.oldLang.getContextBaseRegister();
            Register newCtx = newLang.getContextBaseRegister();
            boolean contextWarning = false;
            if (oldCtx != Register.NO_CONTEXT && defaultTrans.isValueTranslationRequired(oldCtx)) {
                contextWarning = true;
            } else if (oldCtx == Register.NO_CONTEXT && newCtx != Register.NO_CONTEXT) {
                contextWarning = true;
            }
            if (contextWarning) {
                Msg.showWarn(((Object)((Object)this)).getClass(), (Component)GenerateOldLanguagePlugin.this.tool.getToolFrame(), (String)"Translator Warning", (Object)"The new context register differs from the old context!\nA set_context element or custom translator may be required.");
            }
        }
    }

    private class GenerateOldLanguageDialog
    extends DialogComponentProvider {
        private JPanel panel;
        private SelectLanguagePanel selectLangPanel;
        private GhidraFileChooser chooser;

        GenerateOldLanguageDialog(final boolean skipOldLangGeneration) {
            super("Select Old Language", true, true, true, false);
            this.selectLangPanel = new SelectLanguagePanel((LanguageService)new DeprecatedLanguageService(skipOldLangGeneration));
            this.selectLangPanel.setPreferredSize(new Dimension(450, 150));
            this.selectLangPanel.setShowVersion(true);
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.panel.add((Component)this.selectLangPanel, "Center");
            this.addWorkPanel(this.panel);
            this.setStatusText("Please select old language");
            JButton genButton = new JButton(skipOldLangGeneration ? "Select" : "Generate...");
            genButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    File file;
                    Language lang = GenerateOldLanguageDialog.this.selectLangPanel.getSelectedLanguage();
                    if (lang == null) {
                        GenerateOldLanguageDialog.this.setStatusText("Please select old language");
                        return;
                    }
                    if (skipOldLangGeneration) {
                        GenerateOldLanguageDialog.this.close();
                        GenerateTranslatorDialog translatorDlgProvider = new GenerateTranslatorDialog(lang, null);
                        GenerateOldLanguagePlugin.this.tool.showDialog((DialogComponentProvider)translatorDlgProvider);
                        return;
                    }
                    if (GenerateOldLanguageDialog.this.chooser == null) {
                        GenerateOldLanguageDialog.this.chooser = new GhidraFileChooser((Component)GenerateOldLanguageDialog.this.panel);
                        GenerateOldLanguageDialog.this.chooser.setTitle("Specify Old Language Output File");
                        GenerateOldLanguageDialog.this.chooser.setFileFilter((GhidraFileFilter)OLD_LANG_FILTER);
                        GenerateOldLanguageDialog.this.chooser.setApproveButtonText("Create");
                        GenerateOldLanguageDialog.this.chooser.setCurrentDirectory(Application.getApplicationRootDirectory().getFile(false));
                    }
                    if ((file = GenerateOldLanguageDialog.this.chooser.getSelectedFile(true)) == null) {
                        return;
                    }
                    if (!file.getName().endsWith(".lang")) {
                        file = new File(file.getParent(), file.getName() + ".lang");
                    }
                    if (file.exists() && OptionDialog.showYesNoDialog((Component)GenerateOldLanguageDialog.this.panel, (String)"Confirm Overwrite", (String)("Overwrite file " + file.getName() + "?")) != 1) {
                        return;
                    }
                    try {
                        OldLanguageFactory.createOldLanguageFile((Language)lang, (File)file);
                        GenerateOldLanguageDialog.this.close();
                        int resp = OptionDialog.showYesNoDialog((Component)GenerateOldLanguagePlugin.this.tool.getToolFrame(), (String)"Create Simple Translator?", (String)"Old language file generated successfully.\n \nWould you like to create a simple translator to another language?");
                        if (resp == 1) {
                            GenerateTranslatorDialog translatorDlgProvider = new GenerateTranslatorDialog(lang, file);
                            GenerateOldLanguagePlugin.this.tool.showDialog((DialogComponentProvider)translatorDlgProvider);
                        }
                    }
                    catch (LanguageNotFoundException e) {
                        throw new AssertException((Throwable)e);
                    }
                    catch (IOException e) {
                        Msg.showError((Object)this, (Component)GenerateOldLanguageDialog.this.panel, (String)"IO Error", (Object)("Error occurred while generating old language file:\n" + file), (Throwable)e);
                    }
                }
            });
            this.addButton(genButton);
            this.addCancelButton();
        }

        public void close() {
            super.close();
            this.selectLangPanel.dispose();
        }
    }
}

