/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.VariableTypeFieldFactory;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.util.exception.AssertException;
import java.awt.Color;

class VariableTypeLocationDescriptor
extends DataTypeLocationDescriptor {
    VariableTypeLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        if (!(location instanceof VariableTypeFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + location);
        }
    }

    @Override
    protected String generateLabel() {
        return this.getDataTypeName();
    }

    @Override
    protected String getDataTypeName() {
        return this.originalDataType.getDisplayName();
    }

    @Override
    protected DataType getSourceDataType() {
        Variable var = ((VariableLocation)this.getLocation()).getVariable();
        return var.getDataType();
    }

    @Override
    protected DataType getBaseDataType() {
        return ReferenceUtils.getBaseDataType(this.getSourceDataType());
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Variable variable;
        DataType otherBaseDataType;
        if (VariableTypeFieldFactory.class.isAssignableFrom(fieldFactoryClass) && object instanceof Variable && (otherBaseDataType = ReferenceUtils.getBaseDataType((variable = (Variable)object).getDataType())).equals(this.baseDataType)) {
            return new Highlight[]{new Highlight(0, text.length() - 1, highlightColor)};
        }
        return super.getHighlights(text, object, fieldFactoryClass, highlightColor);
    }
}

