/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.graph;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.graph.GraphDisplayBrokerListener;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.service.graph.AttributedGraphExporter;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.GraphException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Manages the active Graph Display Service", description="This plugin searches for available graph display providers and if it finds morethan one, it provides menu options for the user to choose the active provider.", servicesProvided={GraphDisplayBroker.class})
public class GraphDisplayBrokerPlugin
extends Plugin
implements GraphDisplayBroker,
OptionsChangeListener {
    private static final String ACTIVE_GRAPH_PROVIDER = "ACTIVE_GRAPH_PROVIDER";
    private List<GraphDisplayProvider> graphDisplayProviders = new ArrayList<GraphDisplayProvider>();
    private GraphDisplayProvider defaultGraphDisplayProvider;
    private List<GraphDisplayBrokerListener> listeners = new ArrayList<GraphDisplayBrokerListener>();
    private List<GraphSelectionAction> actions = new ArrayList<GraphSelectionAction>();
    private List<AttributedGraphExporter> exporters;

    public GraphDisplayBrokerPlugin(PluginTool tool) {
        super(tool);
        this.loadServices();
        this.buildActions();
    }

    public void writeConfigState(SaveState saveState) {
        if (this.defaultGraphDisplayProvider != null) {
            saveState.putString(ACTIVE_GRAPH_PROVIDER, this.defaultGraphDisplayProvider.getName());
        }
    }

    public void readConfigState(SaveState saveState) {
        String active = saveState.getString(ACTIVE_GRAPH_PROVIDER, null);
        if (active != null) {
            for (GraphDisplayProvider provider : this.graphDisplayProviders) {
                if (!provider.getName().equals(active)) continue;
                this.setDefaultGraphDisplayProvider(provider);
                return;
            }
        }
    }

    private void loadServices() {
        HashSet instances = new HashSet(ClassSearcher.getInstances(GraphDisplayProvider.class));
        this.graphDisplayProviders = new ArrayList<GraphDisplayProvider>(instances);
        Collections.sort(this.graphDisplayProviders, (s1, s2) -> s1.getName().compareTo(s2.getName()));
        this.initializeServices();
        if (!this.graphDisplayProviders.isEmpty()) {
            this.defaultGraphDisplayProvider = this.graphDisplayProviders.get(0);
        }
    }

    private void initializeServices() {
        for (GraphDisplayProvider service : this.graphDisplayProviders) {
            ToolOptions options = this.tool.getOptions("Graph");
            options.addOptionsChangeListener((OptionsChangeListener)this);
            service.initialize(this.tool, (Options)options);
        }
    }

    private void buildActions() {
        if (this.graphDisplayProviders.size() <= 1) {
            return;
        }
        for (GraphDisplayProvider graphDisplayProvider : this.graphDisplayProviders) {
            this.createAction(graphDisplayProvider);
        }
        this.updateActions();
    }

    private void createAction(GraphDisplayProvider provider) {
        GraphSelectionAction action = new GraphSelectionAction(this.getName(), provider);
        this.actions.add(action);
        this.tool.addAction((DockingActionIf)action);
    }

    private void updateActions() {
        for (GraphSelectionAction action : this.actions) {
            action.setSelected(this.defaultGraphDisplayProvider == action.provider);
        }
    }

    protected void notifyListeners() {
        for (GraphDisplayBrokerListener listener : this.listeners) {
            listener.providersChanged();
        }
    }

    @Override
    public GraphDisplayProvider getDefaultGraphDisplayProvider() {
        return this.defaultGraphDisplayProvider;
    }

    @Override
    public void addGraphDisplayBrokerListener(GraphDisplayBrokerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeGraphDisplayBrokerLisetener(GraphDisplayBrokerListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        for (GraphDisplayProvider graphService : this.graphDisplayProviders) {
            graphService.dispose();
        }
    }

    @Override
    public GraphDisplay getDefaultGraphDisplay(boolean reuseGraph, TaskMonitor monitor) throws GraphException {
        if (this.defaultGraphDisplayProvider != null) {
            return this.defaultGraphDisplayProvider.getGraphDisplay(reuseGraph, monitor);
        }
        return null;
    }

    public void setDefaultGraphDisplayProvider(GraphDisplayProvider provider) {
        this.defaultGraphDisplayProvider = provider;
        this.notifyListeners();
        this.updateActions();
    }

    @Override
    public boolean hasDefaultGraphDisplayProvider() {
        return !this.graphDisplayProviders.isEmpty();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        for (GraphDisplayProvider graphService : this.graphDisplayProviders) {
            graphService.optionsChanged((Options)options);
        }
    }

    @Override
    public GraphDisplayProvider getGraphDisplayProvider(String providerName) {
        for (GraphDisplayProvider provider : this.graphDisplayProviders) {
            if (!provider.getName().equals(providerName)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public List<AttributedGraphExporter> getGraphExporters() {
        if (this.exporters == null) {
            this.exporters = ClassSearcher.getInstances(AttributedGraphExporter.class);
        }
        return Collections.unmodifiableList(this.exporters);
    }

    @Override
    public AttributedGraphExporter getGraphExporters(String exporterName) {
        List<AttributedGraphExporter> graphExporters = this.getGraphExporters();
        for (AttributedGraphExporter exporter : graphExporters) {
            if (!exporter.getName().equals(exporterName)) continue;
            return exporter;
        }
        return null;
    }

    private class GraphSelectionAction
    extends ToggleDockingAction {
        private GraphDisplayProvider provider;

        public GraphSelectionAction(String owner, GraphDisplayProvider provider) {
            super(provider.getName(), owner);
            this.provider = provider;
            this.setMenuBarData(new MenuData(new String[]{"&Graph", "Graph Output", provider.getName()}, "z"));
            this.setHelpLocation(provider.getHelpLocation());
        }

        public void actionPerformed(ActionContext context) {
            GraphDisplayBrokerPlugin.this.setDefaultGraphDisplayProvider(this.provider);
        }
    }
}

