/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.dnd.GenericDataFlavor;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeTreeCopyMoveTask;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeTransferable;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataTypeDragNDropHandler
implements GTreeDragNDropHandler {
    private static DataFlavor localDataTypeTreeFlavor = DataTypeDragNDropHandler.createLocalTreeNodeFlavor();
    public static DataFlavor[] allSupportedFlavors = new DataFlavor[]{DataTypeTransferable.localDataTypeFlavor, localDataTypeTreeFlavor};
    public static DataFlavor[] builtinFlavors = new DataFlavor[]{DataTypeTransferable.localBuiltinDataTypeFlavor, localDataTypeTreeFlavor};
    public static DataFlavor[] restrictedFlavors = new DataFlavor[]{localDataTypeTreeFlavor};
    private final GTree tree;
    private final DataTypeManagerPlugin plugin;

    private static DataFlavor createLocalTreeNodeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.List", "Local list of Drag/Drop DataType Tree objects");
        }
        catch (Exception e) {
            Msg.showError(DataTypeDragNDropHandler.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    public DataTypeDragNDropHandler(DataTypeManagerPlugin plugin, GTree tree) {
        this.plugin = plugin;
        this.tree = tree;
    }

    public void drop(GTreeNode destinationNode, Transferable transferable, int dropAction) {
        try {
            List list = (List)transferable.getTransferData(localDataTypeTreeFlavor);
            if (list.contains(destinationNode)) {
                return;
            }
            DataTypeTreeCopyMoveTask.ActionType actionType = dropAction == 1 ? DataTypeTreeCopyMoveTask.ActionType.COPY : DataTypeTreeCopyMoveTask.ActionType.MOVE;
            DataTypeTreeCopyMoveTask task = new DataTypeTreeCopyMoveTask(destinationNode, list, actionType, (DataTypeArchiveGTree)this.tree, this.plugin.getConflictHandler());
            this.plugin.getTool().execute((Task)task, 250);
        }
        catch (UnsupportedFlavorException e) {
            Msg.error((Object)this, (Object)"Unable to perform drop operation", (Throwable)e);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Unable to perform drop operation", (Throwable)e);
        }
    }

    public DataFlavor[] getSupportedDataFlavors(List<GTreeNode> draggedNodes) {
        if (draggedNodes.size() == 1) {
            GTreeNode node = draggedNodes.get(0);
            if (node instanceof DataTypeNode) {
                DataType dataType = ((DataTypeNode)node).getDataType();
                if (dataType instanceof BuiltInDataType || dataType instanceof MissingBuiltInDataType) {
                    return builtinFlavors;
                }
                return allSupportedFlavors;
            }
            if (node instanceof ArchiveNode) {
                return new DataFlavor[0];
            }
        }
        return restrictedFlavors;
    }

    public int getSupportedDragActions() {
        return 3;
    }

    public Object getTransferData(List<GTreeNode> dragUserData, DataFlavor flavor) {
        if (flavor.equals(DataTypeTransferable.localDataTypeFlavor) || flavor.equals(DataTypeTransferable.localBuiltinDataTypeFlavor)) {
            DataTypeNode dataTypeNode = (DataTypeNode)dragUserData.get(0);
            return dataTypeNode.getDataType();
        }
        if (flavor.equals(localDataTypeTreeFlavor)) {
            return dragUserData;
        }
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            List<GTreeNode> nodeList = dragUserData;
            ArrayList<ResourceFile> fileList = new ArrayList<ResourceFile>();
            for (GTreeNode node : nodeList) {
                ArchiveNode archiveNode = (ArchiveNode)node;
                FileArchive archive = (FileArchive)archiveNode.getArchive();
                ResourceFile file = archive.getFile();
                fileList.add(file);
            }
            return fileList;
        }
        return null;
    }

    public boolean isDropSiteOk(GTreeNode destinationNode, DataFlavor[] flavors, int dropAction) {
        if (destinationNode == null || destinationNode.getParent() == null) {
            return false;
        }
        if (!this.containsFlavor(flavors, localDataTypeTreeFlavor)) {
            return false;
        }
        ArchiveNode archiveNode = ((DataTypeTreeNode)destinationNode).getArchiveNode();
        if (archiveNode == null || !archiveNode.isModifiable()) {
            return false;
        }
        if (destinationNode instanceof DataTypeNode && !this.containsFlavor(flavors, DataTypeTransferable.localDataTypeFlavor) && !this.containsFlavor(flavors, DataTypeTransferable.localBuiltinDataTypeFlavor)) {
            return false;
        }
        return !this.isDroppingBuiltin(flavors) || this.isValidBuiltinDropSite(destinationNode);
    }

    private boolean isDroppingBuiltin(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!flavor.equals(DataTypeTransferable.localBuiltinDataTypeFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidBuiltinDropSite(GTreeNode destinationNode) {
        if (!(destinationNode instanceof CategoryNode)) {
            return true;
        }
        CategoryNode categoryNode = (CategoryNode)destinationNode;
        return categoryNode instanceof ArchiveNode;
    }

    private boolean containsFlavor(DataFlavor[] flavors, DataFlavor flavor) {
        for (DataFlavor f : flavors) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public boolean isStartDragOk(List<GTreeNode> dragUserData, int dragAction) {
        return true;
    }
}

