/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentHistory;
import ghidra.program.model.listing.Program;
import ghidra.util.DateUtils;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

class CommentHistoryPanel
extends JPanel {
    private static final String NO_HISTORY = "No History Found";
    private SimpleAttributeSet userAttrSet;
    private SimpleAttributeSet dateAttrSet;
    private SimpleAttributeSet textAttrSet;
    private SimpleAttributeSet tabAttrSet;
    private StyledDocument doc;
    private JTextPane textPane;
    private int commentType;

    CommentHistoryPanel(int commentType) {
        super(new BorderLayout());
        this.setUpAttributes();
        this.commentType = commentType;
        this.create();
    }

    void showCommentHistory(Program program, Address addr) {
        this.textPane.setText("");
        CommentHistory[] historyItems = program.getListing().getCommentHistory(addr, this.commentType);
        try {
            if (historyItems.length == 0) {
                this.doc.insertString(0, NO_HISTORY, null);
                this.doc.setCharacterAttributes(0, NO_HISTORY.length(), this.textAttrSet, true);
                return;
            }
            for (CommentHistory historyItem : historyItems) {
                this.formatHistory(historyItem);
            }
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Error setting comment text field text", (Throwable)e);
        }
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.add((Component)this.textPane, "Center");
        this.doc = this.textPane.getStyledDocument();
    }

    private void formatHistory(CommentHistory history) throws BadLocationException {
        int offset = this.doc.getLength();
        Object userName = history.getUserName();
        if (offset > 0) {
            userName = "\n" + (String)userName;
        }
        this.doc.insertString(offset, (String)userName, this.userAttrSet);
        offset = this.doc.getLength();
        this.doc.insertString(offset, "\t" + DateUtils.formatDateTimestamp((Date)history.getModificationDate()), this.dateAttrSet);
        this.doc.setParagraphAttributes(offset, 1, this.tabAttrSet, false);
        offset = this.doc.getLength();
        this.doc.insertString(offset, "\n" + history.getComments() + "\n", this.textAttrSet);
    }

    private void setUpAttributes() {
        this.textAttrSet = new SimpleAttributeSet();
        this.textAttrSet.addAttribute(StyleConstants.FontFamily, "Monospaced");
        this.textAttrSet.addAttribute(StyleConstants.FontSize, 12);
        this.textAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        this.userAttrSet = new SimpleAttributeSet();
        this.userAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.userAttrSet.addAttribute(StyleConstants.FontSize, 12);
        this.userAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.dateAttrSet = new SimpleAttributeSet();
        this.dateAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.dateAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.dateAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.dateAttrSet.addAttribute(StyleConstants.Foreground, new Color(124, 37, 18));
        this.tabAttrSet = new SimpleAttributeSet();
        TabStop tabs = new TabStop(100.0f, 0, 0);
        StyleConstants.setTabSet(this.tabAttrSet, new TabSet(new TabStop[]{tabs}));
    }
}

