/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Category;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Class;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_ImageInfo;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_MessageReference;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Protocol;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ObjectiveC2_ClassAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Objective-C 2 Class";
    private static final String DESCRIPTION = "An analyzer for extracting and annotating Objective-C 2.0 class structure information.";

    public ObjectiveC2_ClassAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return this.processObjectiveC2(program, monitor, log);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return ObjectiveC2_Constants.isObjectiveC2(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processObjectiveC2(Program program, TaskMonitor monitor, MessageLog log) {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getAddressFactory().getDefaultAddressSpace());
        BinaryReader reader = new BinaryReader(provider, !program.getLanguage().isBigEndian());
        ObjectiveC2_State state = new ObjectiveC2_State(program, monitor, ObjectiveC2_Constants.CATEGORY_PATH);
        try {
            this.processImageInfo(state, reader);
            this.processClassList(state, reader);
            this.processCategoryList(state, reader);
            this.processProtocolList(state, reader);
            this.processClassReferences(state);
            this.processSuperReferences(state);
            this.processProtocolReferences(state);
            this.processNonLazyClassReferences(state);
            this.processSelectorReferences(state);
            this.processMessageReferences(state, reader);
            ObjectiveC1_Utilities.createMethods(state);
            ObjectiveC1_Utilities.createInstanceVariablesC2_OBJC2(state);
            ObjectiveC1_Utilities.fixupReferences(state);
            this.setDataAndRefBlocksReadOnly(state);
        }
        catch (Exception e) {
            String message = e.getMessage();
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            boolean bl = false;
            return bl;
        }
        finally {
            state.dispose();
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void setDataAndRefBlocksReadOnly(ObjectiveC2_State state) {
        MemoryBlock protocolRefsBlock;
        MemoryBlock superRefsBlock;
        MemoryBlock selectorRefsBlock;
        MemoryBlock messageRefsBlock;
        MemoryBlock classRefsBlock;
        Memory memory = state.program.getMemory();
        MemoryBlock dataBlock = memory.getBlock("__objc_data");
        if (dataBlock != null) {
            dataBlock.setWrite(false);
        }
        if ((classRefsBlock = memory.getBlock("__objc_classrefs")) != null) {
            classRefsBlock.setWrite(false);
        }
        if ((messageRefsBlock = memory.getBlock("__objc_msgrefs")) != null) {
            messageRefsBlock.setWrite(false);
        }
        if ((selectorRefsBlock = memory.getBlock("__objc_selrefs")) != null) {
            selectorRefsBlock.setWrite(false);
        }
        if ((superRefsBlock = memory.getBlock("__objc_superrefs")) != null) {
            superRefsBlock.setWrite(false);
        }
        if ((protocolRefsBlock = memory.getBlock("__objc_protorefs")) != null) {
            protocolRefsBlock.setWrite(false);
        }
    }

    private void processProtocolReferences(ObjectiveC2_State state) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Protocol References...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_protorefs");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processClassReferences(ObjectiveC2_State state) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Class References...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_classrefs");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processNonLazyClassReferences(ObjectiveC2_State state) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Non-lazy Class Lists...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_nlclslist");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processSuperReferences(ObjectiveC2_State state) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Super References...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_superrefs");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processCategoryList(ObjectiveC2_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Category Information...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_catlist");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            Address categoryAddress = ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            reader.setPointerIndex(categoryAddress.getOffset());
            ObjectiveC2_Category category = new ObjectiveC2_Category(state, reader);
            category.applyTo();
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processImageInfo(ObjectiveC2_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Image Information...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_imageinfo");
        if (block == null) {
            return;
        }
        Address address = block.getStart();
        reader.setPointerIndex(address.getOffset());
        ObjectiveC2_ImageInfo imageInfo = new ObjectiveC2_ImageInfo(state, reader);
        imageInfo.applyTo();
    }

    private void processProtocolList(ObjectiveC2_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Protocol Information...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_protolist");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            Address protocolAddress = ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            reader.setPointerIndex(protocolAddress.getOffset());
            ObjectiveC2_Protocol protocol = new ObjectiveC2_Protocol(state, reader);
            Namespace namespace = ObjectiveC1_Utilities.createNamespace(state.program, "objc", "Protocols", protocol.getName());
            protocol.applyTo(namespace);
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processClassList(ObjectiveC2_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Class Information...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_classlist");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            Address classAddress = ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            reader.setPointerIndex(classAddress.getOffset());
            ObjectiveC2_Class clazz = new ObjectiveC2_Class(state, reader);
            clazz.applyTo();
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }

    private void processMessageReferences(ObjectiveC2_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Message References...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_msgrefs");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)ObjectiveC2_MessageReference.SIZEOF(state);
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            reader.setPointerIndex(address.getOffset());
            ObjectiveC2_MessageReference messageRef = new ObjectiveC2_MessageReference(state, reader);
            DataType dt = messageRef.toDataType();
            Data messageRefData = state.program.getListing().createData(address, dt);
            Data selData = messageRefData.getComponent(1);
            Object selAddress = selData.getValue();
            Data selStringData = state.program.getListing().getDataAt((Address)selAddress);
            Object selString = selStringData.getValue();
            ObjectiveC1_Utilities.createSymbol(state.program, null, selString + "_message_ref", address);
            address = address.add((long)dt.getLength());
            ++i;
        }
    }

    private void processSelectorReferences(ObjectiveC2_State state) throws Exception {
        state.monitor.setMessage("Objective-C 2.0 Selector References...");
        MemoryBlock block = state.program.getMemory().getBlock("__objc_selrefs");
        if (block == null) {
            return;
        }
        ObjectiveC1_Utilities.clear(state, block);
        long count = block.getSize() / (long)state.pointerSize;
        state.monitor.initialize((long)((int)count));
        Address address = block.getStart();
        int i = 0;
        while ((long)i < count && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)i);
            ObjectiveC1_Utilities.createPointerAndReturnAddressBeingReferenced(state.program, address);
            address = address.add((long)state.pointerSize);
            ++i;
        }
    }
}

