/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.ApplyFunctionDataTypesCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class ApplyDataArchiveAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Apply Data Archives";
    private static final String DESCRIPTION = "Apply known data type archives based on program information.";
    protected static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an analysis bookmark will be created at each symbol address where multiple function definitions were found and not applied.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean createBookmarksEnabled = true;

    public ApplyDataArchiveAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FUNCTION_ID_ANALYSIS.after());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        DataTypeManagerService service = mgr.getDataTypeManagerService();
        List<String> archiveList = DataTypeArchiveUtility.getArchiveList(program);
        ArrayList<DataTypeManager> managerList = new ArrayList<DataTypeManager>();
        monitor.initialize((long)archiveList.size());
        for (String archiveName : archiveList) {
            if (monitor.isCancelled()) break;
            DataTypeManager dtm = null;
            try {
                dtm = service.openDataTypeArchive(archiveName);
                if (dtm == null) {
                    log.appendMsg(NAME, "Failed to locate data type archive: " + archiveName);
                    continue;
                }
                managerList.add(dtm);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof VersionException) {
                    log.appendMsg(NAME, "Unable to open archive " + archiveName + ": " + cause.toString());
                    continue;
                }
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                log.appendMsg(NAME, "Unexpected Error opening archive " + archiveName + ": " + msg);
            }
        }
        monitor.setMessage("Applying Function Signatures...");
        ApplyFunctionDataTypesCmd cmd = new ApplyFunctionDataTypesCmd(managerList, set, SourceType.IMPORTED, false, this.createBookmarksEnabled);
        cmd.applyTo((DomainObject)program, monitor);
        return true;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

