/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;

public class ClearExternalNameCmd
implements Command {
    private String externalName;
    private String status;
    private boolean userDefined = true;

    public ClearExternalNameCmd(String externalName) {
        this.externalName = externalName;
    }

    public boolean applyTo(DomainObject obj) {
        Program p = (Program)obj;
        try {
            p.getExternalManager().setExternalPath(this.externalName, null, this.userDefined);
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Remove External Program Name";
    }
}

