/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.app.cmd.module.AbstractModularizationCmd;
import ghidra.app.services.BlockModelService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;

public class SubroutineModelCmd
extends BackgroundCommand {
    private static final String NEW_MODULE_SUFFIX = " [Subroutines]";
    private static final String PROGRAM_CHANGED_MESSAGE = "Organize algorithm did not run: Program Tree has changed since the algorithm was scheduled.";
    private BlockModelService blockModelService;
    private String treeName;
    private GroupPath groupPath;
    private String modelName;
    private PluginTool tool;

    public SubroutineModelCmd(GroupPath groupPath, String treeName, BlockModelService blockModelService, String modelName) {
        super("Organize By Subroutine", false, true, true);
        this.groupPath = groupPath;
        this.treeName = treeName;
        this.blockModelService = blockModelService;
        this.modelName = modelName;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        ProgramModule root = program.getListing().getRootModule(this.treeName);
        try {
            boolean status = this.changeModel(program, root, monitor);
            if (status && this.getStatusMsg() != null && this.tool != null) {
                this.tool.setStatusInfo(this.getStatusMsg());
            }
            return status;
        }
        catch (NotFoundException e) {
            this.setStatusMsg("Error moving code units: " + e);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.setStatusMsg("Error invoking model " + this.modelName + ": " + msg);
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public void setPluginTool(PluginTool tool) {
        this.tool = tool;
    }

    private boolean changeModel(Program program, ProgramModule root, TaskMonitor monitor) throws NotEmptyException, NotFoundException, DuplicateNameException {
        Group group = this.groupPath.getGroup(program, this.treeName);
        if (group == null) {
            this.setStatusMsg(PROGRAM_CHANGED_MESSAGE);
            return true;
        }
        SubroutineBlockModel subModel = null;
        subModel = this.modelName == null ? (SubroutineBlockModel)this.blockModelService.getActiveSubroutineModel(program) : (SubroutineBlockModel)this.blockModelService.getNewModelByName(this.modelName, program);
        ProgramModule parent = null;
        GroupPath parentPath = this.groupPath.getParentPath();
        if (parentPath != null && (parent = (ProgramModule)parentPath.getGroup(program, this.treeName)) == null && parentPath.getPathCount() > 1) {
            this.setStatusMsg(PROGRAM_CHANGED_MESSAGE);
            return true;
        }
        int index = 0;
        if (parent != null) {
            index = parent.getIndex(group.getName());
        }
        try {
            CodeBlockIterator cbi = null;
            ProgramModule module = null;
            if (group instanceof ProgramModule) {
                if (group.equals(root)) {
                    cbi = subModel.getCodeBlocks(monitor);
                    module = program.getListing().getRootModule(this.treeName);
                } else {
                    module = (ProgramModule)group;
                    String name = module.getName();
                    if (name.indexOf(NEW_MODULE_SUFFIX) == -1) {
                        module.setName(module.getName() + NEW_MODULE_SUFFIX);
                    }
                    cbi = subModel.getCodeBlocksContaining(module.getAddressSet(), monitor);
                }
            } else {
                if (parent == null) {
                    parent = program.getListing().getRootModule(this.treeName);
                }
                ProgramFragment fragment = (ProgramFragment)group;
                cbi = subModel.getCodeBlocksContaining((AddressSetView)fragment, monitor);
                module = this.createModule(parent, fragment.getName() + NEW_MODULE_SUFFIX);
                String newName = module.getName();
                parent.moveChild(newName, index);
            }
            while (cbi.hasNext()) {
                CodeBlock cb = cbi.next();
                ProgramFragment subFragment = this.createFragment(module, cb);
                this.moveCodeUnits(subFragment, cb, monitor);
            }
        }
        catch (CancelledException e) {
            this.setStatusMsg("Organize was cancelled");
            return false;
        }
        AbstractModularizationCmd.cleanTree(root);
        return true;
    }

    private ProgramFragment createFragment(ProgramModule root, CodeBlock block) {
        boolean done = false;
        int index = 0;
        String baseName = block.getName();
        Object name = baseName;
        while (!done) {
            try {
                return root.createFragment((String)name);
            }
            catch (DuplicateNameException e) {
                name = baseName + "(" + ++index + ")";
            }
        }
        return null;
    }

    private ProgramModule createModule(ProgramModule root, String nodeName) {
        boolean done = false;
        int index = 0;
        String baseName = new String(nodeName);
        Object name = baseName;
        while (!done) {
            try {
                return root.createModule((String)name);
            }
            catch (DuplicateNameException e) {
                name = baseName + "(" + ++index + ")";
            }
        }
        return null;
    }

    private void moveCodeUnits(ProgramFragment fragment, CodeBlock block, TaskMonitor monitor) throws NotFoundException {
        AddressRangeIterator iter = block.getAddressRanges();
        while (iter.hasNext() && !monitor.isCancelled()) {
            AddressRange range = (AddressRange)iter.next();
            fragment.move(range.getMinAddress(), range.getMaxAddress());
        }
    }
}

