/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolTable;

public class ExternalEntryCmd
implements Command {
    private SymbolTable st;
    private Address addr;
    private boolean isEntry;

    public ExternalEntryCmd(Address addr, boolean isEntry) {
        this.addr = addr;
        this.isEntry = isEntry;
    }

    public boolean applyTo(DomainObject obj) {
        this.st = ((Program)obj).getSymbolTable();
        if (this.isEntry) {
            this.st.addExternalEntryPoint(this.addr);
        } else {
            this.st.removeExternalEntryPoint(this.addr);
        }
        return true;
    }

    public String getName() {
        return "Set External" + this.isEntry;
    }

    public String getStatusMsg() {
        return "";
    }
}

