/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.program.model.address.AddressRange;

@DebuggerTargetObjectIface(value="MemoryRegion")
public interface TargetMemoryRegion
extends TargetObject {
    public static final String RANGE_ATTRIBUTE_NAME = "_range";
    public static final String READABLE_ATTRIBUTE_NAME = "_readable";
    public static final String WRITABLE_ATTRIBUTE_NAME = "_writable";
    public static final String EXECUTABLE_ATTRIBUTE_NAME = "_executable";
    public static final String MEMORY_ATTRIBUTE_NAME = "_memory";

    @TargetAttributeType(name="_range", required=true, hidden=true)
    default public AddressRange getRange() {
        return this.getTypedAttributeNowByName(RANGE_ATTRIBUTE_NAME, AddressRange.class, null);
    }

    @TargetAttributeType(name="_readable", required=true, hidden=true)
    default public boolean isReadable() {
        return this.getTypedAttributeNowByName(READABLE_ATTRIBUTE_NAME, Boolean.class, false);
    }

    @TargetAttributeType(name="_writable", required=true, hidden=true)
    default public boolean isWritable() {
        return this.getTypedAttributeNowByName(WRITABLE_ATTRIBUTE_NAME, Boolean.class, false);
    }

    @TargetAttributeType(name="_executable", required=true, hidden=true)
    default public boolean isExecutable() {
        return this.getTypedAttributeNowByName(EXECUTABLE_ATTRIBUTE_NAME, Boolean.class, false);
    }

    @TargetAttributeType(name="_memory", required=true, fixed=true, hidden=true)
    default public TargetMemory getMemory() {
        return this.getTypedAttributeNowByName(MEMORY_ATTRIBUTE_NAME, TargetMemory.class, null);
    }
}

