/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.agent;

import ghidra.framework.LoggingInitialization;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.SocketAddress;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import log.LogListener;
import log.LogPanelAppender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;

public class AgentWindow
extends JFrame
implements WindowListener,
LogListener {
    public static final int MAX_LOG_CHARS = 100000;
    protected final JTextArea logArea = new JTextArea();
    protected final JScrollPane logScroll = new JScrollPane(this.logArea);

    public AgentWindow(String title, SocketAddress localAddress) {
        super(title);
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.add((Component)new JLabel("<html>This agent is listening at <b>" + localAddress + "</b>. Close this window to terminate it.</html>"), "North");
        this.logArea.setEditable(false);
        this.logArea.setFont(Font.decode("Monospaced"));
        this.logArea.setAutoscrolls(true);
        this.logScroll.setAutoscrolls(true);
        this.add(this.logScroll);
        this.setMinimumSize(new Dimension(400, 300));
        this.setVisible(true);
        System.setProperty("log4j.configuration", "agent.log4j.xml");
        LoggingInitialization.initializeLoggingSystem();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        Appender appender = config.getAppender("logPanel");
        if (!(appender instanceof LogPanelAppender)) {
            Msg.error((Object)this, (Object)"Couldn't find LogPanelAppender instance in the Log4j context. Nothing will be logged to the agent's window.");
        } else {
            LogPanelAppender logPanelAppender = (LogPanelAppender)appender;
            logPanelAppender.setLogListener((LogListener)this);
        }
    }

    public void messageLogged(String message, boolean isError) {
        Object fMessage = isError ? "<font color=\"red\">" + message + "</font>" : message;
        Swing.runIfSwingOrRunLater(() -> this.lambda$messageLogged$0((String)fMessage));
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("User closed agent window. Exiting");
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private /* synthetic */ void lambda$messageLogged$0(String fMessage) {
        String allText = this.logArea.getText() + fMessage + "\n";
        this.logArea.setText(allText.substring(Math.max(0, allText.length() - 100000), allText.length()));
        JScrollBar vScroll = this.logScroll.getVerticalScrollBar();
        vScroll.setValue(vScroll.getMaximum());
    }
}

