/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbConsoleOutputListener;
import agent.gdb.manager.GdbEventsListenerAdapter;
import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbManager;
import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.manager.reason.GdbReason;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelImplUtils;
import agent.gdb.model.impl.GdbModelSelectableObject;
import agent.gdb.model.impl.GdbModelTargetAttachable;
import agent.gdb.model.impl.GdbModelTargetAvailableContainer;
import agent.gdb.model.impl.GdbModelTargetBreakpointContainer;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetInferiorContainer;
import agent.gdb.model.impl.GdbModelTargetStackFrame;
import agent.gdb.model.impl.GdbModelTargetThread;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetModelRoot;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Session", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetSession
extends DefaultTargetModelRoot
implements TargetAccessConditioned,
TargetAttacher,
TargetInterpreter,
TargetInterruptible,
TargetLauncher,
TargetActiveScope,
TargetEventScope,
TargetFocusScope,
GdbConsoleOutputListener,
GdbEventsListenerAdapter {
    protected static final String GDB_PROMPT = "(gdb)";
    protected final GdbModelImpl impl;
    protected String display = "GNU gdb (GDB)";
    protected final GdbModelTargetInferiorContainer inferiors;
    protected final GdbModelTargetAvailableContainer available;
    protected final GdbModelTargetBreakpointContainer breakpoints;
    private boolean accessible = true;
    protected GdbModelSelectableObject focus;
    protected String debugger = "gdb";

    public GdbModelTargetSession(GdbModelImpl impl, TargetObjectSchema schema) {
        super((AbstractDebuggerObjectModel)impl, "Session", schema);
        this.impl = impl;
        this.inferiors = new GdbModelTargetInferiorContainer(this);
        this.available = new GdbModelTargetAvailableContainer(this);
        this.breakpoints = new GdbModelTargetBreakpointContainer(this);
        this.changeAttributes(List.of(), Map.of(this.inferiors.getName(), this.inferiors, this.available.getName(), this.available, this.breakpoints.getName(), this.breakpoints, "_accessible", this.accessible, "_prompt", GDB_PROMPT, "_display", this.display, "_parameters", GdbModelTargetInferior.PARAMETERS, "_supported_attach_kinds", GdbModelTargetInferior.SUPPORTED_KINDS, "_focus", this), "Initialized");
        impl.gdb.addEventsListener(this);
        impl.gdb.addConsoleOutputListener(this);
        this.getVersion();
    }

    @TargetAttributeType(name="Inferiors", required=true, fixed=true)
    public GdbModelTargetInferiorContainer getInferiors() {
        return this.inferiors;
    }

    @TargetAttributeType(name="Available", required=true, fixed=true)
    public GdbModelTargetAvailableContainer getAvailable() {
        return this.available;
    }

    @TargetAttributeType(name="Breakpoints", required=true, fixed=true)
    public GdbModelTargetBreakpointContainer getBreakpoints() {
        return this.breakpoints;
    }

    protected void getVersion() {
        ((CompletableFuture)((CompletableFuture)this.impl.gdb.waitForPrompt().thenCompose(__ -> this.impl.gdb.consoleCapture("show version", GdbConsoleExecCommand.CompletesWithRunning.CANNOT))).thenAccept(out -> {
            this.debugger = out;
            this.display = out.split("\n")[0].strip();
            this.changeAttributes(List.of(), Map.of("_display", this.display), "Version refreshed");
        })).exceptionally(e -> {
            this.model.reportError((Object)this, "Could not get GDB version", e);
            this.debugger = "gdb";
            return null;
        });
    }

    public String getDisplay() {
        return this.display;
    }

    @Override
    public void output(GdbManager.Channel gdbChannel, String out) {
        TargetConsole.Channel dbgChannel;
        switch (gdbChannel) {
            case STDOUT: {
                dbgChannel = TargetConsole.Channel.STDOUT;
                break;
            }
            case STDERR: {
                dbgChannel = TargetConsole.Channel.STDERR;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ((DebuggerModelListener)this.listeners.fire).consoleOutput((TargetObject)this, dbgChannel, out);
    }

    @Override
    public void inferiorSelected(GdbInferior inferior, GdbCause cause) {
        if (inferior.getKnownThreads().isEmpty()) {
            GdbModelTargetInferior inf = this.inferiors.getTargetInferior(inferior);
            this.setFocus(inf);
        }
    }

    protected boolean isFocusInternallyDriven(GdbCause cause) {
        if (cause == null || cause == GdbCause.Causes.UNCLAIMED) {
            return false;
        }
        if (cause instanceof GdbEvent) {
            return false;
        }
        if (cause instanceof GdbPendingCommand) {
            GdbPendingCommand pcmd = (GdbPendingCommand)cause;
            GdbCommand cmd = pcmd.getCommand();
            return cmd.isFocusInternallyDriven();
        }
        return true;
    }

    @Override
    public void threadSelected(GdbThread thread, GdbStackFrame frame, GdbCause cause) {
        if (this.isFocusInternallyDriven(cause)) {
            return;
        }
        GdbModelTargetInferior inf = this.inferiors.getTargetInferior(thread.getInferior());
        GdbModelTargetThread t = inf.threads.getTargetThread(thread);
        if (frame == null) {
            this.setFocus(t);
            return;
        }
        GdbModelTargetStackFrame f = t.stack.getTargetFrame(frame);
        this.setFocus(f);
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
        this.changeAttributes(List.of(), Map.of("_accessible", this.accessible), "Accessibility changed");
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        List cmdLineArgs = TargetLauncher.CmdLineParser.tokenize((String)((String)TargetLauncher.TargetCmdLineLauncher.PARAMETER_CMDLINE_ARGS.get(args)));
        Boolean useStarti = (Boolean)GdbModelTargetInferior.PARAMETER_STARTI.get(args);
        return this.impl.gateFuture((CompletableFuture)((CompletableFuture)this.impl.gdb.availableInferior().thenCompose(inf -> GdbModelImplUtils.launch(inf, cmdLineArgs, useStarti, () -> this.inferiors.getTargetInferior((GdbInferior)inf).environment.refreshInternal()))).thenApply(__ -> null));
    }

    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        GdbModelTargetAttachable mine = (GdbModelTargetAttachable)this.impl.assertMine(GdbModelTargetAttachable.class, (TargetObject)attachable);
        return this.attach(mine.pid);
    }

    public CompletableFuture<Void> attach(long pid) {
        return this.impl.gateFuture((CompletableFuture)this.impl.gdb.availableInferior().thenCompose(inf -> inf.attach(pid).thenApply(__ -> null)));
    }

    public CompletableFuture<Void> interrupt() {
        try {
            this.impl.gdb.sendInterruptNow();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Could not interrupt", (Throwable)e);
        }
        return AsyncUtils.NIL;
    }

    public CompletableFuture<Void> execute(String cmd) {
        return this.impl.gateFuture((CompletableFuture)this.impl.gdb.console(cmd).exceptionally(GdbModelImpl::translateEx));
    }

    public CompletableFuture<String> executeCapture(String cmd) {
        return this.impl.gateFuture((CompletableFuture)this.impl.gdb.consoleCapture(cmd).exceptionally(GdbModelImpl::translateEx));
    }

    public CompletableFuture<Void> requestActivation(TargetObject obj) {
        this.impl.assertMine(TargetObject.class, obj);
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        for (TargetObject cur = obj; cur != null; cur = cur.getParent()) {
            if (!(cur instanceof GdbModelSelectableObject)) continue;
            GdbModelSelectableObject sel = (GdbModelSelectableObject)cur;
            return sel.setActive();
        }
        return AsyncUtils.NIL;
    }

    public CompletableFuture<Void> requestFocus(TargetObject obj) {
        this.impl.assertMine(TargetObject.class, obj);
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        for (TargetObject cur = obj; cur != null; cur = cur.getParent()) {
            if (!(cur instanceof GdbModelSelectableObject)) continue;
            GdbModelSelectableObject sel = (GdbModelSelectableObject)cur;
            this.setFocus(sel);
            return AsyncUtils.NIL;
        }
        return AsyncUtils.NIL;
    }

    protected void invalidateMemoryAndRegisterCaches() {
        this.inferiors.invalidateMemoryAndRegisterCaches();
    }

    protected void setFocus(GdbModelSelectableObject focus) {
        this.focus = focus;
        this.changeAttributes(List.of(), Map.of("_focus", this.focus), "Focus changed");
    }

    public GdbModelSelectableObject getFocus() {
        return this.focus;
    }

    @Override
    public void inferiorStateChanged(GdbInferior inf, Collection<GdbThread> threads, GdbState state, GdbThread thread, GdbCause cause, GdbReason reason) {
        GdbStateChangeRecord sco = new GdbStateChangeRecord(inf, threads, state, thread, cause, reason);
        CompletableFuture<Void> infUpdates = CompletableFuture.allOf(this.breakpoints.stateChanged(sco), this.inferiors.stateChanged(sco));
        infUpdates.whenComplete((v, t) -> {
            if (thread == null) {
                return;
            }
            if (this.impl.gdb.getKnownThreads().get(thread.getId()) != thread) {
                return;
            }
            thread.setActive(true).exceptionally(ex -> {
                this.impl.reportError(this, "Could not restore event thread", (Throwable)ex);
                return null;
            });
        });
    }

    @Override
    public void threadStateChanged(GdbThread thread, GdbState state, GdbCause cause, GdbReason reason) {
        TargetThread targetThread = (TargetThread)this.impl.getModelObject(thread);
        this.changeAttributes(List.of(), List.of(), Map.of("_event_thread", targetThread), reason.desc());
    }
}

